package hiro.yoshioka.sql.resource.twitter;

import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.IDBTable;

import java.io.Serializable;

public class TwitterDBColumn extends DBColumn implements Serializable {
	private static final long serialVersionUID = -3471341335813323405L;
	private TwitterColumnType columnType;

	public TwitterDBColumn(IDBTable table, TwitterColumnType columnType) {
		super(table);
		this.columnType = columnType;
	}

	public TwitterColumnType getTwitterColumnType() {
		return columnType;
	}

	@Override
	public String getDefaultConditionValue() {
		TwitterDBTable table = (TwitterDBTable) getParent();
		TwitterDBSchema schema = (TwitterDBSchema) table.getParent();
		return columnType.getDefaultValue(getRoot(), schema.getSchemaType(),
				table.getTwitterTableType());
	}

}