package hiro.yoshioka.sql.notes.ddl;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Form extends Document {
	private static final long serialVersionUID = -6342467648865199103L;
	String name;
	String alias;
	String bgcolor;
	Boolean nocompose;
	Boolean publicaccess;
	Boolean defaultVal;

	public Form(Database parent, Node atts) {
		super(parent,atts);
		NamedNodeMap names = atts.getAttributes();
		name = getAttrValueString(names, "name");
		alias = getAttrValueString(names, "alias");
		bgcolor = getAttrValueString(names, "bgcolor");
		nocompose = getAttrValueBoolean(names, "nocompose");
		publicaccess = getAttrValueBoolean(names, "publicaccess");
		defaultVal = getAttrValueBoolean(names, "default");
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row, File imgDir) {
		StringBuilder buf = new StringBuilder();
		for (Par par : parList) {
			buf.append(par.toHtmlString(rdh, row, imgDir));
		}
		return buf.toString();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAlias() {
		return alias;
	}

	public void setAlias(String alias) {
		this.alias = alias;
	}

	public String getBgcolor() {
		return bgcolor;
	}

	public void setBgcolor(String bgcolor) {
		this.bgcolor = bgcolor;
	}

	public Boolean getNocompose() {
		return nocompose;
	}

	public void setNocompose(Boolean nocompose) {
		this.nocompose = nocompose;
	}

	public Boolean getPublicaccess() {
		return publicaccess;
	}

	public void setPublicaccess(Boolean publicaccess) {
		this.publicaccess = publicaccess;
	}

	public Boolean getDefaultVal() {
		return defaultVal;
	}

	public void setDefaultVal(Boolean defaultVal) {
		this.defaultVal = defaultVal;
	}

}
