package hiro.yoshioka.sql.resource.xml;

import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.util.StringUtil;

import java.nio.charset.Charset;

public class DBColumnValue extends DBResouceValue {
	int maxColumnNameLength;

	private SQLDataType type;

	private int size;

	private int decimalDigits;

	private boolean notnull;

	private boolean pkey;

	private boolean indexColumn;

	private String dataTypeString;

	public DBColumnValue() {
	}

	public DBColumnValue(DBTableValue parent, IDBColumn column) {
		this(column);
		this.parent = parent;
	}

	public DBColumnValue(IDBColumn column) {
		super(column);
		setType(column.getDataType());
		setSize(column.getSize());
		setDecimalDigits(column.getDecimalDigits());
		setNotnull(column.isNotNull());
		setPkey(column.isPkey());
		setIndexColumn(column.isIndexColumn());
		setMaxColumnNameLength(column.getMaxColumnNameLength());
		setDataTypeString(column.getDataTypeString());
	}

	public String getNameWithCommentLimLen() {
		return getNameWithCommentLimLen(Charset.defaultCharset());
	}

	public String getNameWithAsCommentLimLen() {
		return getNameWithAsCommentLimLen(Charset.defaultCharset());
	}

	public String getNameWithCommentLimLen(Charset charset) {
		if (getComment().length() > 0) {
			return String.format("%s \"%s\"", getName(), StringUtil.cutByBytes(
					getComment(), maxColumnNameLength, charset));
		}
		return getName();
	}

	public String getNameWithAsCommentLimLen(Charset charset) {
		if (getComment().length() > 0) {
			return String.format("%s As \"%s\"", getName(), StringUtil
					.cutByBytes(getComment(), maxColumnNameLength, charset));
		}
		return getName();
	}

	public int getDecimalDigits() {
		return decimalDigits;
	}

	public void setDecimalDigits(int decimalDigits) {
		this.decimalDigits = decimalDigits;
	}

	public boolean isIndexColumn() {
		return indexColumn;
	}

	public void setIndexColumn(boolean indexColumn) {
		this.indexColumn = indexColumn;
	}

	public boolean isNotnull() {
		return notnull;
	}

	public void setNotnull(boolean notnull) {
		this.notnull = notnull;
	}

	public boolean isPkey() {
		return pkey;
	}

	public void setPkey(boolean pkey) {
		this.pkey = pkey;
	}

	public int getSize() {
		return size;
	}

	public void setSize(int size) {
		this.size = size;
	}

	public SQLDataType getType() {
		return type;
	}

	public void setType(SQLDataType type) {
		this.type = type;
	}

	public int getMaxColumnNameLength() {
		return maxColumnNameLength;
	}

	public void setMaxColumnNameLength(int maxColumnNameLength) {
		this.maxColumnNameLength = maxColumnNameLength;
	}

	public String getDataTypeString() {
		return dataTypeString;
	}

	public void setDataTypeString(String dataTypeString) {
		this.dataTypeString = dataTypeString;
	}
}
