package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.SQLDataType;

import java.io.File;

public class BindInfo {
	public static final BindInfo[] EMPTY_ARRAYS = new BindInfo[0];
	public static final int STRING = 0;
	int kind = STRING;
	String name;
	String value;
	transient IDBTable table;
	transient IToken targetToken;
	transient IToken questionToken;

	public static final String[] TYPE_STRING = { "STRING", "NUMERIC", "TIME",
			"DATE", "TIMESTAMP", "BLOB", "BINARY" };

	public BindInfo(String image) {
		this(image, null, null);
	}

	public BindInfo(String image, IToken coltoken, IToken last) {
		this.name = image;
		this.targetToken = coltoken;
		this.questionToken = last;
	}

	public BindInfo(IDBTable table, IToken coltoken, IToken last) {
		this.table = table;
		this.name = coltoken.getImage();
		this.targetToken = coltoken;
		this.questionToken = last;

		if (table == null) {
			return;
		}
		IDBColumn column = (IDBColumn) table.getResource(this.name);
		if (column != null) {
			SQLDataType dataType = column.getDataType();
			if (dataType.isNumerics()) {
				kind = 1;
			} else if (dataType.isTime()) {
				kind = 2;
			} else if (dataType.isDate()) {
				kind = 3;
			} else if (dataType.isTimeStamp()) {
				kind = 4;
			} else if (dataType.isBlob()) {
				kind = 5;
			} else if (dataType.isBinary()) {
				kind = 6;
			}
		}
	}

	public IToken getQuestionToken() {
		return questionToken;
	}

	public IToken getTargetToken() {
		return targetToken;
	}

	public IDBTable getTable() {
		return table;
	}

	public String getTarget() {
		return name;
	}

	public boolean isString() {
		return kind == 0;
	}

	public boolean isNumeric() {
		return kind == 1;
	}

	public boolean isTime() {
		return kind == 2;
	}

	public boolean isDate() {
		return kind == 3;
	}

	public boolean isTimeStamp() {
		return kind == 4;
	}

	public boolean isBlob() {
		return kind == 5;
	}

	public boolean isBinary() {
		return kind == 6;
	}

	public void setTarget(String str) {
		name = str;
	}

	public Object getValue() {
		switch (kind) {
		case 5:
		case 6:
			if (value != null) {
				return new File(value);
			}
			break;
		}
		return value;
	}

	public String getStringValue() {
		return value;
	}

	public void setValue(String str) {
		value = str;
	}

	public int getType() {
		return kind;
	}

	public String getTypeString() {
		return TYPE_STRING[kind];
	}

	public void setTypeString(String str) {
		for (int i = 0; i < TYPE_STRING.length; i++) {
			if (TYPE_STRING[i].equals(str)) {
				kind = i;
				break;
			}
		}
	}

	public void setType(int i) {
		kind = i;
	}

	@Override
	public String toString() {
		return getTarget() + "[" + getValue() + "]【" + getTypeString() + "】";
	}
}
