package hiro.yoshioka.util;

import static java.util.Arrays.deepEquals;
import static java.util.Arrays.deepHashCode;

public class Tuple {

	public static class Pair<L, R> {
		private L left;
		private R right;

		public Pair(L left, R right) {
			this.left = left;
			this.right = right;
		}

		public final L getLeft() {
			return left;
		}

		public final R getRight() {
			return right;
		}

		public void setLeft(L left) {
			this.left = left;
		}

		public void setRight(R right) {
			this.right = right;
		}

		public boolean equals(Object obj) {
			if (obj == null) {
				return false;
			}
			if (obj instanceof Pair) {
				return deepEquals(((Pair) obj).getObjectArrays(),
						getObjectArrays());
			}
			return false;
		}

		public int hashCode() {
			return deepHashCode(getObjectArrays());
		}

		protected Object[] getObjectArrays() {
			return new Object[] { this.left, this.right };
		}

		@Override
		public String toString() {
			return String
					.format("Left:[%s] Right:[%s] ", getLeft(), getRight());
		}
	}

	public static class Triplet<L, C, R> extends Pair<L, R> {

		private C center;

		public Triplet(L left, C center, R right) {
			super(left, right);
			this.center = center;
		}

		public final C getCenter() {
			return center;
		}

		public void setCenter(C center) {
			this.center = center;
		}

		@Override
		public boolean equals(Object obj) {
			if (obj == null) {
				return false;
			}
			if (obj instanceof Triplet) {
				return deepEquals(((Triplet) obj).getObjectArrays(),
						getObjectArrays());
			}
			return false;
		}

		@Override
		protected Object[] getObjectArrays() {
			return new Object[] { getLeft(), getCenter(), getRight() };
		}

		@Override
		public String toString() {
			return String.format("Left:[%s] Center:[%s] Right:[%s] ",
					getLeft(), getCenter(), getRight());
		}
	}

}