package wolfcsveditor.popup.actions;

import hiro.yoshioka.csveditor.view.CDHDiffView;
import hiro.yoshioka.wolfcsveditor.Activator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CompareCSVAction implements IObjectActionDelegate {
	private IStructuredSelection selection;
	private Shell shell;

	/**
	 * Constructor for Action1.
	 */
	public CompareCSVAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		shell = targetPart.getSite().getShell();
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		if (selection == null) {
			return;
		}

		List<IFile> list = new ArrayList<IFile>();
		for (Iterator ite = selection.iterator(); ite.hasNext();) {
			Object o = ite.next();
			if (o instanceof IFile) {
				IFile f = (IFile) o;
				if (f.getName().endsWith(".csv")) {
					list.add(f);
				}
			}
		}
		IFile f0 = list.get(0);
		IFile f1 = list.get(1);
		CDHDiffView view = Activator.showAndCreateDiffRstView(f0.getName());
		try {
			view.setInput(list.toArray(new IFile[list.size()]), true);
			view.setPartName(String.format("Diff[%s:%s]", f0.getName(),
					f1.getName()));
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection) selection;
		} else {
			this.selection = null;
		}
	}

}
