package hiro.yoshioka.csveditor.view;

import hiro.yoshioka.eclipse.core.CoreUtil;
import hiro.yoshioka.sdh.CDHTableViewer;
import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;

public class CDHDiffView extends ViewPart {
	protected transient Log fLogger = LogFactory.getLog(getClass());

	public static final String ID = "WolfCSVEditor.CsvDiffViewID";

	CSVRecordDataHolder cdh0, cdh1;

	int[] fMatchingPos;

	private CDHTableViewer viewer0, viewer1;

	public void createPartControl(Composite parent) {

		try {
			SashForm sash = new SashForm(parent, SWT.HORIZONTAL);

			viewer0 = new CDHTableViewer(sash, SWT.BORDER | SWT.MULTI
					| SWT.FULL_SELECTION | SWT.HIDE_SELECTION | SWT.H_SCROLL
					| SWT.V_SCROLL);
			viewer0.setSupportDiff(true);
			// viewer0.setInputAdjustHeader(null);
			viewer1 = new CDHTableViewer(sash, SWT.BORDER | SWT.MULTI
					| SWT.FULL_SELECTION | SWT.HIDE_SELECTION | SWT.H_SCROLL
					| SWT.V_SCROLL);
			viewer1.setSupportDiff(true);
			viewer1.setMaxMultiLine(5);
			viewer1.setSupportChart(true);
			// viewer1.setInputAdjustHeader(null);
			sash.setWeights(new int[] { 3, 7 });
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void setInput(IFile[] csvs, boolean isVirtual) throws CoreException {
		try {
			cdh0 = new CSVRecordDataHolder(CoreUtil.cnvFile(csvs[0]),
					csvs[0].getCharset(), null, true);
			cdh1 = new CSVRecordDataHolder(CoreUtil.cnvFile(csvs[1]),
					csvs[1].getCharset(), null, true);

			fMatchingPos = new int[] { 0 };
			for (String k : cdh0.getKey()) {
				if ("title".equals(k)) {
					break;
				}
				fMatchingPos[0]++;
			}

			DiffToResultSetDataHolder differ = new DiffToResultSetDataHolder();
			try {
				differ.diffConfigure(cdh0, cdh1, fMatchingPos);
				differ.diff();
			} catch (Exception e) {
				e.printStackTrace();
			}

			viewer0.setInputAdjustDatum(cdh0);
			viewer1.setInputAdjustDatum(cdh1);
			IViewSite viewSite = getViewSite();
			IActionBars actionBars = viewSite.getActionBars();
			IStatusLineManager manager = actionBars.getStatusLineManager();
			manager.setMessage(differ.getDiffInfomation());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void setPartName(String partName) {
		super.setPartName(partName);
	}

	@Override
	public void setFocus() {
		viewer0.getControl().setFocus();
	}

}