package hiro.yoshioka.csveditor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModelFactory;

public class CSVDocumentProvider extends FileDocumentProvider {
	protected transient Log fLogger = LogFactory.getLog(getClass());

	protected IDocument createDocument(Object element) throws CoreException {
		IDocument document = super.createDocument(element);

		return document;
	}

	@Override
	public IAnnotationModel getAnnotationModel(Object element) {
		IAnnotationModel model = super.getAnnotationModel(element);
		if (model == null) {
			try {
				model = createAnnotationModel(element);
			} catch (CoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (model == null) {
			FileEditorInput inp = (FileEditorInput) element;
			ResourceMarkerAnnotationModelFactory fc = new ResourceMarkerAnnotationModelFactory();
			model = fc.createAnnotationModel(inp.getPath());
		}

		return model;
	}

	@Override
	protected void doSaveDocument(IProgressMonitor monitor, Object element,
			IDocument document, boolean overwrite) throws CoreException {
		try {
			if (fLogger.isInfoEnabled()) {
				fLogger.info("element is " + element);
			}
			super.doSaveDocument(monitor, element, document, overwrite);
		} catch (RuntimeException e) {
			fLogger.error("Save error", e);
		}
	}
}