/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

import java.io.IOException;
import java.io.InputStream;

public class CachedInputStream
extends InputStream {
    private static final int DefaultCacheSize = 1024;
    private InputStream in;
    private byte[] cache;
    private int cachePosition;
    private int cacheLimit;
    private boolean markPositionIsInCache;
    private byte[] markCache;
    private int markCachePosition;
    private int markCacheLimit;

    private CachedInputStream() {
    }

    public CachedInputStream(InputStream in) {
        this(in, 1024);
    }

    public CachedInputStream(InputStream in, int cacheSize) {
        if (in == null || cacheSize <= 0) {
            if (in == null) {
                throw new IllegalArgumentException("in must not be null.");
            }
            throw new IllegalArgumentException("cacheSize must be one or more.");
        }
        this.in = in;
        this.cache = new byte[cacheSize];
        this.cachePosition = 0;
        this.cacheLimit = 0;
        this.markPositionIsInCache = false;
        this.markCache = null;
        this.markCachePosition = 0;
        this.markCacheLimit = 0;
    }

    public int read() throws IOException {
        if (this.cachePosition < this.cacheLimit) {
            return this.cache[this.cachePosition++] & 0xFF;
        }
        this.fillCache();
        if (this.cachePosition < this.cacheLimit) {
            return this.cache[this.cachePosition++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int index, int length) throws IOException {
        int requested = length;
        while (length > 0) {
            if (this.cacheLimit <= this.cachePosition) {
                this.fillCache();
                if (this.cacheLimit <= this.cachePosition) {
                    if (requested != length) break;
                    return -1;
                }
            }
            int copylen = Math.min(length, this.cacheLimit - this.cachePosition);
            System.arraycopy(this.cache, this.cachePosition, buffer, index, copylen);
            index += copylen;
            length -= copylen;
            this.cachePosition += copylen;
        }
        return requested - length;
    }

    public long skip(long length) throws IOException {
        long requested = length;
        while (0L < length) {
            if (this.cacheLimit <= this.cachePosition) {
                this.fillCache();
                if (this.cacheLimit <= this.cachePosition) break;
            }
            long skiplen = Math.min(length, (long)(this.cacheLimit - this.cachePosition));
            length -= skiplen;
            this.cachePosition += (int)skiplen;
        }
        return requested - length;
    }

    public void mark(int readLimit) {
        readLimit = (readLimit -= this.cacheLimit - this.cachePosition) / this.cache.length * this.cache.length + (readLimit % this.cache.length == 0 ? 0 : this.cache.length);
        this.in.mark(readLimit);
        if (this.markCache == null) {
            this.markCache = (byte[])this.cache.clone();
        } else {
            System.arraycopy(this.cache, 0, this.markCache, 0, this.cacheLimit);
        }
        this.markCacheLimit = this.cacheLimit;
        this.markCachePosition = this.cachePosition;
        this.markPositionIsInCache = true;
    }

    public void reset() throws IOException {
        if (this.markPositionIsInCache) {
            this.cachePosition = this.markCachePosition;
        } else {
            if (!this.in.markSupported()) {
                throw new IOException("not support mark()/reset().");
            }
            if (this.markCache == null) {
                throw new IOException("not marked.");
            }
            this.in.reset();
            System.arraycopy(this.markCache, 0, this.cache, 0, this.markCacheLimit);
            this.cacheLimit = this.markCacheLimit;
            this.cachePosition = this.markCachePosition;
        }
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int available() throws IOException {
        return this.cacheLimit - this.cachePosition + this.in.available() / this.cache.length * this.cache.length;
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.cache = null;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markPositionIsInCache = false;
    }

    private void fillCache() throws IOException {
        this.markPositionIsInCache = false;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        int read = 0;
        while (read >= 0 && this.cacheLimit < this.cache.length) {
            read = this.in.read(this.cache, this.cacheLimit, this.cache.length - this.cacheLimit);
            if (read <= 0) continue;
            this.cacheLimit += read;
        }
    }
}

