/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.CaseInsensitiveColumnMatcher;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.IndexData;
import com.healthmarketscience.jackcess.Table;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Joiner {
    private final Index _fromIndex;
    private final List<IndexData.ColumnDescriptor> _fromCols;
    private final IndexCursor _toCursor;
    private final Object[] _entryValues;

    private Joiner(Index fromIndex, IndexCursor toCursor) {
        this._fromIndex = fromIndex;
        this._fromCols = this._fromIndex.getColumns();
        this._entryValues = new Object[this._fromCols.size()];
        this._toCursor = toCursor;
    }

    public static Joiner create(Table fromTable, Table toTable) throws IOException {
        return Joiner.create(fromTable.getForeignKeyIndex(toTable));
    }

    public static Joiner create(Index fromIndex) throws IOException {
        Index toIndex = fromIndex.getReferencedIndex();
        IndexCursor toCursor = IndexCursor.createCursor(toIndex.getTable(), toIndex);
        toCursor.setColumnMatcher(CaseInsensitiveColumnMatcher.INSTANCE);
        return new Joiner(fromIndex, toCursor);
    }

    public Joiner createReverse() throws IOException {
        return Joiner.create(this.getToTable(), this.getFromTable());
    }

    public Table getFromTable() {
        return this.getFromIndex().getTable();
    }

    public Index getFromIndex() {
        return this._fromIndex;
    }

    public Table getToTable() {
        return this.getToCursor().getTable();
    }

    public Index getToIndex() {
        return this.getToCursor().getIndex();
    }

    public IndexCursor getToCursor() {
        return this._toCursor;
    }

    public boolean hasRows(Map<String, ?> fromRow) throws IOException {
        this.toEntryValues(fromRow);
        return this._toCursor.findFirstRowByEntry(this._entryValues);
    }

    public Map<String, Object> findFirstRow(Map<String, ?> fromRow) throws IOException {
        return this.findFirstRow(fromRow, null);
    }

    public Map<String, Object> findFirstRow(Map<String, ?> fromRow, Collection<String> columnNames) throws IOException {
        return this.hasRows(fromRow) ? this._toCursor.getCurrentRow(columnNames) : null;
    }

    public Iterator<Map<String, Object>> findRows(Map<String, ?> fromRow) {
        return this.findRows(fromRow, null);
    }

    public Iterator<Map<String, Object>> findRows(Map<String, ?> fromRow, Collection<String> columnNames) {
        this.toEntryValues(fromRow);
        return this._toCursor.entryIterator(columnNames, this._entryValues);
    }

    public Iterable<Map<String, Object>> findRowsIterable(Map<String, ?> fromRow) {
        return this.findRowsIterable(fromRow, null);
    }

    public Iterable<Map<String, Object>> findRowsIterable(final Map<String, ?> fromRow, final Collection<String> columnNames) {
        return new Iterable<Map<String, Object>>(){

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return Joiner.this.findRows(fromRow, columnNames);
            }
        };
    }

    public boolean deleteRows(Map<String, ?> fromRow) throws IOException {
        boolean removed = false;
        Iterator<Map<String, Object>> iter = this.findRows(fromRow, Collections.<String>emptySet());
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
            removed = true;
        }
        return removed;
    }

    private void toEntryValues(Map<String, ?> fromRow) {
        for (int i = 0; i < this._entryValues.length; ++i) {
            this._entryValues[i] = fromRow.get(this._fromCols.get(i).getName());
        }
    }
}

