package sql.notes;

import hiro.yoshioka.ast.sql.util.IProposalableParserUtil;
import hiro.yoshioka.ast.sql.util.ProposalParserFactory;
import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.DominoTransactionRequest;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.notes.NotesRunnerUpdate;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.DBUserPass;
import hiro.yoshioka.sql.resource.notes.NotesDBSchema;
import hiro.yoshioka.sql.resource.notes.NotesDBTable;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NotesDataInsertsTester {

	private static IProposalableParserUtil getParserUtil(
			ConnectionProperties connectionProperties, String sql_statement) {
		ProposalParserFactory factory = ProposalParserFactory
				.createFactory(connectionProperties.getDriverName());
		return factory.createParserUtil(sql_statement,
				connectionProperties.getDBRootResource());
	}

	public static void main(String[] args) {

		ConnectionProperties p = new ConnectionProperties();

		// dom
		p.setHost("192.168.1.21");
		p.setAuthenticate(new DBUserPass("yuko admin/org", "password"));

		NotesDBSchema schema = new NotesDBSchema(null);
		schema.setName("hoge");
		NotesDBTable table = new NotesDBTable(schema);
		table.setName("ReportDoc");

		ClassManager cm = new ClassManager();

		try {
			cm.add_lib(new File(
					"C:/Program Files/IBM/Lotus/Domino/data/domino/java/NCSO.jar"));
			ExecutorService ex = Executors.newSingleThreadExecutor();
			Future<ResultSetDataHolder2> future = null;

			DominoTransactionRequest request = new DominoTransactionRequest(
					SQLOperationType.PREPARED_EXECUTE, p, table);
			request.addListener(new RequestAdaptor() {
				@Override
				public void beginTask(String taskName, int row) {
					System.out.println(" --[BEGIN]" + taskName + "/" + row);
				}

				@Override
				public void subTask(String subTaskName) {
					System.out.println("   --[SUB_TASK]" + subTaskName);
				}
			});
			for (int i = 0; i < 1000; i++) {
				Map<String, Object> map = new HashMap<String, Object>();
				map.put("float_value", 10.4f);
				map.put("richtext1", "あいうろ\nかきくけこ");
				map.put("colors", "00FFFF00");
				request.addParams(map);
			}
			future = ex.submit(new NotesRunnerUpdate(cm, request));

			try {
				System.out.println("result=" + future.get());
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
			ex.shutdown();
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

	}
}
