package hiro.yoshioka.sql.params;

import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.util.StringUtil;

import java.sql.DatabaseMetaData;

public class OutPutParameter extends Parameter {
	public final SQLDataType datatype;

	public final int columnType;

	public final String name;

	String result;

	public OutPutParameter(int index, SQLDataType datatype) {
		this(StringUtil.EMPTY_STRING, index, datatype,
				DatabaseMetaData.procedureResultUnknown);
	}

	public OutPutParameter(String name, int index, SQLDataType datatype,
			int columnType) {
		super(index);
		this.name = name;
		this.datatype = datatype;
		this.columnType = columnType;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String string) {
		this.result = string;
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append("index=").append(index);
		buf.append(" name=[").append(name);
		buf.append("] datatype=").append(datatype);
		buf.append("] columntype=").append(columnType);
		buf.append(" result=[").append(result).append("]");
		return buf.toString();
	}

}
