package hiro.yoshioka.sql.evernote;

import hiro.yoshioka.sql.ResultSetUtil;
import hiro.yoshioka.sql.resource.evernote.EvernoteColumnType;
import hiro.yoshioka.sql.resource.evernote.EvernoteSchemaType;
import hiro.yoshioka.sql.resource.evernote.EvernoteTableType;
import hiro.yoshioka.sql.resource.twitter.TwitterColumnType;
import hiro.yoshioka.util.SQLUtil;
import hiro.yoshioka.util.StringUtil;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;

import twitter4j.Paging;
import twitter4j.TwitterException;

import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.limits.Constants;
import com.evernote.edam.notestore.NoteCollectionCounts;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.type.Data;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.edam.type.Tag;

public class EvernoteResultSet implements ResultSet {
	protected Log fLogger = LogFactory.getLog(getClass());
	private NoteStore.Client noteStore;
	EvernoteSchemaType schemaType;
	EvernoteTableType tableType;
	List<EvernoteColumnType> selectColumnList;
	ResultSetMetaData meta;
	Object targetObject;
	NoteList noteList;
	List<LinkedNotebook> linkedNoteList;

	private int limitNum;
	List<Object> targetRowObjectList;
	private Map<String, Method> methodCacheMap = new HashMap<String, Method>();
	private int cursor = -1;
	private Map<String, Object> params;
	// search
	private String search_guid;
	private String search_notebook_guid;
	private Set<String> serach_tag_guidSet;

	final protected ResultSetUtil rsUtil;
	private String authToken;

	/**
	 * 
	 * @param noteStore
	 * @param schemaType
	 * @param tableType
	 * @param selectColumnList
	 * @param params
	 * @throws Exception
	 * 
	 *             params:
	 */
	public EvernoteResultSet(NoteStore.Client noteStore, String authToken,
			EvernoteSchemaType schemaType, EvernoteTableType tableType,
			List<EvernoteColumnType> selectColumnList,
			Map<String, Object> params, ResultSetUtil rsUtil) throws Exception {
		this.noteStore = noteStore;
		this.authToken = authToken;
		this.selectColumnList = selectColumnList;
		this.meta = new MyMeta();
		this.schemaType = schemaType;
		this.tableType = tableType;
		this.rsUtil = rsUtil;
		if (params == null) {
			this.params = Collections.EMPTY_MAP;
		} else {
			this.params = params;
		}
		init();
	}

	private void init() throws Exception {
		initParams();
		int count = 10;
		int pageCount;
		Paging paging;
		switch (schemaType) {
		case NoteBook:
		case LinkedNoteBook:
			if (selectColumnList == null || selectColumnList.size() == 0) {
				selectColumnList = EvernoteColumnType.NOTE_LIST;
			}

			if (!StringUtil.isEmpty(this.search_guid)) {
				this.noteList = new NoteList();
				// string authenticationToken,
				// Types.Guid guid,
				// bool withContent,
				// bool withResourcesData,
				// bool withResourcesRecognition,
				// bool withResourcesAlternateData)
				try {
					Note note = this.noteStore.getNote(authToken,
							this.search_guid, false, false, false, false);
					this.noteList.addToNotes(note);
				} catch (Exception e) {
					fLogger.fatal(StringUtil.EMPTY_STRING, e);
					this.noteList = new NoteList();
				}
			} else {
				NoteFilter filter = new NoteFilter();
				if (!StringUtil.isEmpty(this.search_notebook_guid)) {
					filter.setNotebookGuid(this.search_notebook_guid);
				}
				if (this.serach_tag_guidSet != null) {
					filter.setTagGuids(new ArrayList<String>(
							this.serach_tag_guidSet));
				}
				int limit = this.limitNum;
				if (limit > Constants.EDAM_USER_NOTES_MAX) {
					limit = Constants.EDAM_USER_NOTES_MAX;
				}

				try {
					NoteCollectionCounts c = this.noteStore.findNoteCounts(
							authToken, filter, false);
					System.out.println("co=" + c);

					this.noteList = this.noteStore.findNotes(this.authToken,
							filter, 0, limit);
				} catch (Exception e) {
					fLogger.fatal(StringUtil.EMPTY_STRING, e);
					this.noteList = new NoteList();
				}
			}
			break;

		// case LinkedNoteBook:
		// if (selectColumnList == null || selectColumnList.size() == 0) {
		// selectColumnList = EvernoteColumnType.NOTE_LIST;
		// }
		//
		// //
		// // NoteFilter filter = new NoteFilter();
		// // if (!StringUtil.isEmpty(this.search_notebook_guid)) {
		// // filter.setNotebookGuid(this.search_notebook_guid);
		// // }
		// // if (this.serach_tag_guidSet != null) {
		// // filter.setTagGuids(new ArrayList<String>(
		// // this.serach_tag_guidSet));
		// // }
		// // int limit = this.limitNum;
		// // if (limit > Constants.EDAM_USER_NOTES_MAX) {
		// // limit = Constants.EDAM_USER_NOTES_MAX;
		// // }
		//
		// try {
		// this.linkedNoteList = this.noteStore
		// .listLinkedNotebooks(authToken);
		//
		// } catch (Exception e) {
		// fLogger.fatal(StringUtil.EMPTY_STRING, e);
		// this.linkedNoteList = Collections.EMPTY_LIST;
		// }
		//
		// break;
		case SharedNoteBook:

			break;
		case Tags:

			break;
		}
	}

	private void initParams() throws IllegalStateException, TwitterException {
		if (this.params.containsKey(EvernoteColumnType.guid.name())) {
			Object o = this.params.get(EvernoteColumnType.guid.name());
			if (o instanceof String) {
				search_guid = (String) o;
			}
		}
		if (this.params.containsKey(EvernoteColumnType.notebookGuid.name())) {
			Object o = this.params.get(EvernoteColumnType.notebookGuid.name());
			if (o instanceof String) {
				search_notebook_guid = (String) o;
			}
		}
		if (this.params.containsKey(EvernoteColumnType.tagGuids.name())) {
			Object o = this.params.get(EvernoteColumnType.tagGuids.name());
			if (o instanceof String) {
				for (String tag : ((String) o).split(",")) {
					tag = tag.trim();
					if (tag.length() > 0) {
						if (serach_tag_guidSet == null) {
							this.serach_tag_guidSet = new HashSet<String>();
						}
						this.serach_tag_guidSet.add(tag);
					}
				}
			}
		}
		if (this.params.containsKey(TwitterColumnType.limitNum.name())) {
			Object o = this.params.get(TwitterColumnType.limitNum.name());
			if (o instanceof Integer) {
				limitNum = (Integer) o;
			}
		}
		if (limitNum <= 0) {
			limitNum = Integer.MAX_VALUE;
		}
	}

	@Override
	public boolean next() throws SQLException {
		cursor++;

		boolean ret = false;
		int sum = 0;
		switch (this.schemaType) {
		case NoteBook:
		case LinkedNoteBook:
			ret = noteList.getNotesSize() > cursor;
			break;
		}

		if (ret) {
			try {
				resetTargetRowObject();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		return ret;
	}

	private int getTargetObjectIdx(String columnName) throws SQLException {
		int idx = 1;
		for (EvernoteColumnType column : selectColumnList) {
			if (column.name().equalsIgnoreCase(columnName)) {
				return idx;
			}
			idx++;
		}
		System.err.println("no such column[" + columnName + "]");
		throw new SQLException("no such column[" + columnName + "]");
	}

	private Object getTargetObjectData(String columnName) throws SQLException {
		int idx = 1;
		for (EvernoteColumnType column : selectColumnList) {
			if (column.name().equalsIgnoreCase(columnName)) {
				return getTargetObjectData(idx);
			}
			idx++;
		}
		System.err.println("no such column[" + columnName + "]");
		throw new SQLException("no such column[" + columnName + "]");
	}

	private Object getTargetObjectData(int idx) {
		if (targetRowObjectList == null) {
			return new SQLException("no data");
		}
		if (targetRowObjectList.size() <= (idx - 1)) {
			return new SQLException("no data");
		}
		return targetRowObjectList.get(idx - 1);
	}

	private void resetTargetRowObject() throws EDAMUserException,
			EDAMSystemException, EDAMNotFoundException, TException {
		Object valueObject = null;

		Note fullAccessNote = null;
		switch (this.schemaType) {
		case NoteBook:
		case LinkedNoteBook:
			boolean withContent = selectColumnList
					.contains(EvernoteColumnType.content);
			boolean withResource = rsUtil.isMakeBlobData()
					&& selectColumnList.contains(EvernoteColumnType.resources);
			fullAccessNote = this.noteStore.getNote(authToken, noteList
					.getNotes().get(cursor).getGuid(), withContent,
					withResource, false, false);
			valueObject = fullAccessNote;
			break;
		}
		targetRowObjectList = new ArrayList<Object>();
		Method method = null;
		for (int i = 0; i < selectColumnList.size(); i++) {
			EvernoteColumnType selectColumn = selectColumnList.get(i);
			try {
				switch (this.schemaType) {
				case NoteBook:
				case LinkedNoteBook:
					switch (this.tableType) {
					case NoteBook:
					case LinkedNoteBook:
						switch (selectColumn) {
						case resources:
							extractResource(fullAccessNote);
							continue;
						case tagNames:
							extractTag(fullAccessNote);
							continue;
						case content:
							targetRowObjectList
									.add(fullAccessNote.getContent());
							continue;
						}
						break;
					}
					break;
				default:
					break;
				}
				String key = selectColumn + "/" + valueObject.getClass();
				method = methodCacheMap.get(key);
				if (method == null) {
					method = valueObject.getClass().getDeclaredMethod(
							selectColumn.getValueMethod());
					method.setAccessible(true);
					methodCacheMap.put(key, method);
				}
				switch (selectColumn.getColumnType()) {
				case DATE:
					targetRowObjectList.add(method.invoke(valueObject));
					break;
				default:
					targetRowObjectList.add(method.invoke(valueObject));
					break;
				}
			} catch (Exception e) {
				System.err.println("================================");
				System.out.println("selectColumn=" + selectColumn);
				System.out.println("method=" + method);
				e.printStackTrace();
			}
		}
	}

	private boolean extractTag(Note note) throws EDAMUserException,
			EDAMSystemException, EDAMNotFoundException, TException {
		List<String> tagList = note.getTagGuids();
		if (tagList == null || tagList.size() == 0) {
			targetRowObjectList.add(null);
			return false;
		}
		List<String> nameList = new ArrayList<String>();
		for (String guid : tagList) {
			Tag tag = noteStore.getTag(authToken, guid);
			nameList.add(tag.getName());
		}
		targetRowObjectList.add(nameList.toString());
		return true;
	}

	private boolean extractResource(Note note) {
		List<Resource> resourceList = note.getResources();
		if (resourceList == null) {
			targetRowObjectList.add(null);
		} else {
			StringBuilder buf = new StringBuilder();
			for (Resource res : resourceList) {
				ResourceAttributes attr = res.getAttributes();
				if (rsUtil.isMakeBlobData()) {
					Data data = res.getData();
					byte[] dataBody = data.getBody();
					if (dataBody == null || dataBody.length == 0) {
						fLogger.fatal("Resource#Data#body is nothing..."
								+ attr.getFileName());
					} else {
						String filePath = null;
						if (StringUtil.isEmpty(attr.getFileName())) {
							filePath = rsUtil.makeBinary(
									EvernoteColumnType.resources.name(),
									dataBody);
						} else {
							filePath = rsUtil.makeBinary(
									EvernoteColumnType.resources.name(),
									dataBody, attr.getFileName());
						}
						if (buf.length() > 0) {
							buf.append(StringUtil.LINE_SEPARATOR);
						}
						buf.append(filePath);
					}
				} else {
					if (buf.length() > 0) {
						buf.append(StringUtil.LINE_SEPARATOR);
					}
					if (StringUtil.isEmpty(attr.getFileName())) {
						fLogger.fatal("Resource#Data#fileName is nothing..."
								+ attr);
					} else {
						buf.append(attr.getFileName());
					}
				}
			}
			targetRowObjectList.add(buf.toString());
		}
		return true;
	}

	class MyMeta implements ResultSetMetaData {

		@Override
		public boolean isWrapperFor(Class<?> iface) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public <T> T unwrap(Class<T> iface) throws SQLException {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public String getCatalogName(int column) throws SQLException {
			return null;
		}

		@Override
		public String getColumnClassName(int column) throws SQLException {
			return selectColumnList.get(column - 1).getDataTypeString();
		}

		@Override
		public int getColumnCount() throws SQLException {
			if (EvernoteResultSet.this.selectColumnList == null) {
				return 0;
			}
			return selectColumnList.size();
		}

		@Override
		public int getColumnDisplaySize(int column) throws SQLException {
			return selectColumnList.get(column - 1).name().length();
		}

		@Override
		public String getColumnLabel(int column) throws SQLException {
			return selectColumnList.get(column - 1).name();
		}

		@Override
		public String getColumnName(int column) throws SQLException {
			return selectColumnList.get(column - 1).name();
		}

		@Override
		public int getColumnType(int column) throws SQLException {
			return selectColumnList.get(column - 1).getColumnType().getType();
		}

		@Override
		public String getColumnTypeName(int column) throws SQLException {
			return selectColumnList.get(column - 1).getDataTypeString();
		}

		@Override
		public int getPrecision(int column) throws SQLException {
			return 0;
		}

		@Override
		public int getScale(int column) throws SQLException {
			return 0;
		}

		@Override
		public String getSchemaName(int column) throws SQLException {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public String getTableName(int column) throws SQLException {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public boolean isAutoIncrement(int column) throws SQLException {
			return false;
		}

		@Override
		public boolean isCaseSensitive(int column) throws SQLException {
			return false;
		}

		@Override
		public boolean isCurrency(int column) throws SQLException {
			return false;
		}

		@Override
		public boolean isDefinitelyWritable(int column) throws SQLException {
			return false;
		}

		@Override
		public int isNullable(int column) throws SQLException {
			// TODO Auto-generated method stub
			return 0;
		}

		@Override
		public boolean isReadOnly(int column) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public boolean isSearchable(int column) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public boolean isSigned(int column) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public boolean isWritable(int column) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

	}

	@Override
	public boolean isWrapperFor(Class<?> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public <T> T unwrap(Class<T> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean absolute(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void afterLast() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void beforeFirst() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void cancelRowUpdates() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void clearWarnings() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void close() throws SQLException {
		targetObject = null;
		targetRowObjectList = null;
		serach_tag_guidSet = null;
		noteList = null;
	}

	@Override
	public void deleteRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public int findColumn(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public boolean first() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public Array getArray(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Array getArray(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getAsciiStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getAsciiStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BigDecimal getBigDecimal(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BigDecimal getBigDecimal(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getBinaryStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getBinaryStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Blob getBlob(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Blob getBlob(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean getBoolean(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean getBoolean(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public byte getByte(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public byte getByte(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public byte[] getBytes(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public byte[] getBytes(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Reader getCharacterStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Reader getCharacterStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Clob getClob(int idx) throws SQLException {
		Object o = getTargetObjectData(idx);
		return SQLUtil.getClobOfSql(o);
	}

	@Override
	public Clob getClob(String columnName) throws SQLException {
		return getClob(getTargetObjectIdx(columnName));
	}

	@Override
	public int getConcurrency() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String getCursorName() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Date getDate(int idx) throws SQLException {
		Object o = getTargetObjectData(idx);
		return SQLUtil.getDateOfSql(o);
	}

	// private java.util.Date cnvDateSqlToUtil(java.sql.Date d) {
	// return new java.util.Date(d.getTime());
	// }
	//
	// private java.sql.Date cnvDateUtilToSql(java.util.Date d) {
	// return new java.sql.Date(d.getTime());
	// }

	@Override
	public Date getDate(String columnName) throws SQLException {
		Object o = getTargetObjectData(columnName);
		return SQLUtil.getDateOfSql(o);
	}

	@Override
	public Date getDate(int arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Date getDate(String arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public double getDouble(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public double getDouble(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getFetchDirection() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getFetchSize() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public float getFloat(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public float getFloat(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getHoldability() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getInt(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getInt(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public long getLong(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public long getLong(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public ResultSetMetaData getMetaData() throws SQLException {
		return this.meta;
	}

	@Override
	public Reader getNCharacterStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Reader getNCharacterStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public NClob getNClob(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public NClob getNClob(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getNString(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getNString(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object getObject(int idx) throws SQLException {
		return getTargetObjectData(idx);
	}

	@Override
	public Object getObject(String columnName) throws SQLException {
		return getObject(getTargetObjectIdx(columnName));
	}

	@Override
	public Object getObject(int arg0, Map<String, Class<?>> arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object getObject(String arg0, Map<String, Class<?>> arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Ref getRef(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Ref getRef(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int getRow() throws SQLException {
		return (int) cursor;
	}

	@Override
	public RowId getRowId(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RowId getRowId(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SQLXML getSQLXML(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SQLXML getSQLXML(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public short getShort(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public short getShort(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public Statement getStatement() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getString(int idx) throws SQLException {
		Object o = getTargetObjectData(idx);
		return rsUtil.getStringOf(o);
	}

	@Override
	public String getString(String columnName) throws SQLException {
		return getString(getTargetObjectIdx(columnName));
	}

	@Override
	public Time getTime(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Time getTime(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Time getTime(int arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Time getTime(String arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Timestamp getTimestamp(int idx) throws SQLException {
		Object o = getTargetObjectData(idx);
		if (o == null) {
			return null;
		}
		if (o instanceof java.util.Date) {
			java.util.Date d = (java.util.Date) o;
			return new Timestamp(d.getTime());
		} else if (o instanceof Long) {
			Long l = (Long) o;
			if (l == 0) {
				return null;
			}
			return new Timestamp(l);
		} else {
			System.err.println("what is this ? " + o);
		}
		return null;
	}

	@Override
	public Timestamp getTimestamp(String columnName) throws SQLException {
		return getTimestamp(getTargetObjectIdx(columnName));
	}

	@Override
	public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Timestamp getTimestamp(String arg0, Calendar arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int getType() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public URL getURL(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public URL getURL(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getUnicodeStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getUnicodeStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void insertRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean isAfterLast() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isBeforeFirst() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isClosed() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isFirst() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isLast() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean last() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void moveToCurrentRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void moveToInsertRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean previous() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void refreshRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean relative(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean rowDeleted() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean rowInserted() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean rowUpdated() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setFetchDirection(int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void setFetchSize(int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateArray(int arg0, Array arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateArray(String arg0, Array arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(int arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(String arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(int arg0, InputStream arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(String arg0, InputStream arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(int arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(String arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBigDecimal(String arg0, BigDecimal arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(int arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(String arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(int arg0, InputStream arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(String arg0, InputStream arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(int arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(String arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(int arg0, Blob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(String arg0, Blob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(int arg0, InputStream arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(String arg0, InputStream arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(int arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(String arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBoolean(int arg0, boolean arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBoolean(String arg0, boolean arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateByte(int arg0, byte arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateByte(String arg0, byte arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBytes(int arg0, byte[] arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBytes(String arg0, byte[] arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(int arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(String arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(int arg0, Reader arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(String arg0, Reader arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(int arg0, Clob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(String arg0, Clob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(int arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(String arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateDate(int arg0, Date arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateDate(String arg0, Date arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateDouble(int arg0, double arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateDouble(String arg0, double arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateFloat(int arg0, float arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateFloat(String arg0, float arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateInt(int arg0, int arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateInt(String arg0, int arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateLong(int arg0, long arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateLong(String arg0, long arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNCharacterStream(int arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNCharacterStream(String arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNCharacterStream(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNCharacterStream(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(int arg0, NClob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(String arg0, NClob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(int arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(String arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNString(int arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNString(String arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNull(int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNull(String arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateObject(int arg0, Object arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateObject(String arg0, Object arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateObject(int arg0, Object arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateObject(String arg0, Object arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRef(int arg0, Ref arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRef(String arg0, Ref arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRowId(int arg0, RowId arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRowId(String arg0, RowId arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateShort(int arg0, short arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateShort(String arg0, short arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateString(int arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateString(String arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateTime(int arg0, Time arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateTime(String arg0, Time arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateTimestamp(String arg0, Timestamp arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean wasNull() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

}
