package hiro.yoshioka.sql;

public interface IMYSQLDBConst {
	String SELECT_SESSION_INFO = "SHOW FULL PROCESSLIST  ";
	String SHOW_CREATE_TABLE = "SHOW CREATE TABLE ";
	String JDBC_URL_EXAMPLE = "jdbc:mysql://192.168.0.1/<user_db>?zeroDateTimeBehavior=convertToNull";
	String SELECT_TABLE_LIST = "SELECT TABLE_NAME, "
			+ "CASE TABLE_TYPE WHEN 'BASE TABLE' THEN 'TABLE' "
			+ " WHEN 'SYSTEM VIEW' THEN 'VIEW' " + " ELSE 'TABLE' "
			+ "END  AS TABLE_TYPE " + "FROM INFORMATION_SCHEMA.TABLES "
			+ "WHERE TABLE_SCHEMA = ?   ";
	String SELECT_PRIMARY_KEY = " SELECT k.column_name                                                            "
			+ " FROM information_schema.table_constraints t                                     "
			+ " JOIN information_schema.key_column_usage k USING(constraint_name,table_schema,table_name)"
			+ " WHERE t.constraint_type='PRIMARY KEY' AND upper(t.table_schema)=? AND upper(t.table_name)=?";

	String SELECT_ALL_PROCEDURE_LIST = "SELECT ROUTINE_SCHEMA, ROUTINE_NAME,ROUTINE_TYPE,ROUTINE_COMMENT,ROUTINE_DEFINITION"
			+ " FROM INFORMATION_SCHEMA.ROUTINES"
			+ " WHERE ROUTINE_TYPE IN ('PROCEDURE','FUNCTION')";
	String SELECT_SCHEMAS_PROCEDURE_LIST = "SELECT ROUTINE_SCHEMA, ROUTINE_NAME,ROUTINE_TYPE,ROUTINE_COMMENT,ROUTINE_DEFINITION"
			+ " FROM INFORMATION_SCHEMA.ROUTINES"
			+ " WHERE upper(ROUTINE_SCHEMA) = ?  AND ROUTINE_TYPE IN ('PROCEDURE','FUNCTION')";
}
