package hiro.yoshioka.sql.resource.notes;

import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.SQLDataType;

import java.io.Serializable;

public class NotesDBColumn extends DBColumn implements Serializable {
	private static final long serialVersionUID = -5178849167324045521L;
	private ItemType itemType;

	public NotesDBColumn(IDBTable table) {
		super(table);
	}

	public boolean isRichText() {
		return ItemType.RICHTEXT.equals(itemType);
	}

	@Override
	public boolean isNotNull() {
		return super.isNotNull();
	}

	public void setItemType(ItemType itemType) {
		this.itemType = itemType;
	}

	@Override
	public int getSize() {
		if (this.itemType == null) {
			super.getSize();
		}
		return this.itemType.getSize(getName());
	}

	@Override
	public SQLDataType getDataType() {
		if (this.itemType == null) {
			super.getDataType();
		}
		return this.itemType.getSQLTypes();
	}

	@Override
	public String getDataTypeString() {
		if (this.itemType == null) {
			return super.getDataTypeString();
		}
		return this.itemType.toString();
	}
}