package hiro.yoshioka.sql.resource;

import java.util.List;
import java.util.Set;

public interface IDBTable extends IDBResource, ITextExtension {
	IDBTable[] EMPTY_ARRAYS = new IDBTable[0];

	IDBColumn[] getColumns();

	IDBColumn[] getColumnsForSelectionDialog();

	DBCrossRefference[] getCrossReferences();

	public int[] getPkPositions();

	public boolean hasPk();

	boolean isTable();

	boolean isView();

	void setSelectAll();

	boolean getSelectAll();

	boolean isSynonym();

	boolean isSystem();

	boolean isProcudeure();

	ProcedureType getProcedureType();

	boolean isFunction();

	boolean isDictionary();

	boolean isShadow();

	String getCatalog();

	String getUCatalog();

	void setCatalog(String catalog);

	IDBColumn[] getInputColumns();

	IDBColumn[] getOutputColumns();

	IDBColumn getReturnColumn();

	// void addIndex(String index_name,String column_name);
	/**
	 * @param schemaString
	 * @param tableNameString
	 * @param columnString
	 * @return
	 */
	List<IDBResource> getProposal(IDBSchema another, String schemaString,
			String tableNameString, String columnString, Set<String> aliasSet);

	IDBTable clone();

	void removeAllColumns();

	TableType getTableType();

}