package hiro.yoshioka.sql.resource;

import java.util.List;
import java.util.Set;

public interface IDBSchema extends IDBResource {
	IDBTable[] getTableOrSystemTables();

	IDBTable[] getTableOrViews();

	IDBTable[] getProcedures();

	IDBTrigger[] getTriggers();

	IDBSequence getSequence(String name);

	IDBSequence[] getSequences();

	void removeAll();

	void putSequence(IDBSequence sequence);

	IDBTable[] getFunctions();

	IDBTable getTableResource(String name);

	IDBTable getTableResource(String name, boolean considerAlias);

	IDBTable[] getSynonyms();

	IDBTrigger getTrigger(String name);

	IDBTable getProcedure(String name);

	void putTable(IDBTable table);

	void putProcedure(IDBTable table);

	void putTrigger(IDBTrigger trigger);

	String getCurrentDefaultString();

	boolean isDefault();

	boolean isCurrent();

	/**
	 * @param tableNameString
	 * @return
	 */
	List getResourceListStartsWith(String tableNameString);

	List<IDBTable> getTablesList(Set<TableType> typeSet);

}