package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.sql.resource.IDBTable;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ASTEditorTableListHolder {
	private boolean _hasBrace;
	Set<IDBTable> tableSet;
	IDBTable cache;

	boolean hasBrace() {
		return _hasBrace;
	}

	public void addTable(IDBTable table) {
		if (table == null) {
			return;
		}
		if (tableSet == null) {
			tableSet = new LinkedHashSet<IDBTable>();
		}
		tableSet.add(table);
		cache = table;
	}

	public String toString() {
		return "TABLE LISTS " + tableSet;
	}

	public boolean hasMultiTable() {
		if (tableSet == null || tableSet.size() < 1) {
			return false;
		}
		return true;
	}

	public int size() {
		if (tableSet == null) {
			return 0;
		}
		return tableSet.size();
	}

	@Override
	public int hashCode() {
		if (tableSet == null) {
			return super.hashCode();
		}
		return tableSet.hashCode();
	}

	@Override
	public boolean equals(Object arg0) {
		if (arg0 == null) {
			return false;
		}
		if (!(arg0 instanceof ASTEditorTableListHolder)) {
			return false;
		}
		ASTEditorTableListHolder you = (ASTEditorTableListHolder) arg0;
		if (tableSet == null) {
			if (you.tableSet == null) {
				return true;
			} else {
				return false;
			}
		} else {
			if (you.tableSet == null) {
				return false;
			} else {
				return tableSet.equals(you.tableSet);
			}
		}
	}

	// ----------------------------------------------------------------------------
	/**
	 * @return IDBTableのリストイテレータ
	 */
	// ----------------------------------------------------------------------------
	public Iterator<IDBTable> iterator() {
		if (tableSet == null) {
			return Collections.EMPTY_SET.iterator();
		}
		return tableSet.iterator();
	}

	public IDBTable getFirstTable() {
		if (tableSet == null || tableSet.size() == 0) {
			return null;
		}
		return iterator().next();
	}

	public IDBTable getLastTable() {
		return cache;
	}

	/**
	 * @param list2
	 */
	public void addTableList(List list2) {
		if (list2 == null) {
			return;
		}
		for (Object o : list2) {
			if (o instanceof IDBTable) {
				addTable((IDBTable) o);
			}
		}
	}

}