package hiro.yoshioka.util;

public enum LineSeparatorEnum {
	/** HTML_BR */
	HTML_BR("HTML_BR", "<br>"),
	/** CR */
	CR("MAC_OS", "\r"),
	/** LF */
	LF("UNIX", "\n"),
	/** LF */
	REG_LF("UNIX", "\\\\n"),
	/** CRLF */
	CRLF("WINDOWS", "\r\n");

	private String osName;
	private String lineSeparatorString;

	private LineSeparatorEnum(String osName, String lineSeparatorString) {
		this.osName = osName;
		this.lineSeparatorString = lineSeparatorString;
	}

	public String getOsName() {
		return osName;
	}

	public String getLineSeparator() {
		return lineSeparatorString;
	}

	public static LineSeparatorEnum getThisLineSeparator(String text) {
		if (text.indexOf(CRLF.getLineSeparator()) > 0) {
			return CRLF;
		} else if (text.indexOf(CR.getLineSeparator()) > 0) {
			return CR;
		} else if (text.indexOf(LF.getLineSeparator()) > 0) {
			return LF;
		}
		return CRLF;
	}
}
