package hiro.yoshioka.csveditor.dialog;

import hiro.yoshioka.csveditor.Messages;
import hiro.yoshioka.util.CSVUtil;
import hiro.yoshioka.util.LineSeparatorEnum;
import hiro.yoshioka.util.StringUtil;
import jp.sf.orangesignal.csv.CsvConfig;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CSVConfigDialog extends Dialog {
	char[] COMBO_CODE = { StringUtil.SINGLE_QUOTE_CHAR,
			StringUtil.DOUBLE_QUOTE_CHAR, StringUtil.TAB_CHAR, ',', ' ',
			StringUtil.YEN_CHAR };
	String[] COMBO_TEXTS = { Messages.CSVConfigDialog_SingleQuotation,
			Messages.CSVConfigDialog_DoubleQuotation,
			Messages.CSVConfigDialog_TAB, Messages.CSVConfigDialog_COMMA,
			Messages.CSVConfigDialog_SPACE, Messages.CSVConfigDialog_YEN_MARK };
	String[][] COMBO_NEW_LINE_TEXTS = {
			{ LineSeparatorEnum.CR.getLineSeparator(),  LineSeparatorEnum.LF.getLineSeparator(),
				 LineSeparatorEnum.CRLF.getLineSeparator(),null },
			{ Messages.CSVConfigDialog_CR, Messages.CSVConfigDialog_LF,
					Messages.CSVConfigDialog_CRLF,
					Messages.CSVConfigDialog_EMPTY_STRING,
					Messages.CSVConfigDialog_DO_NOTHING } };

	MyCsvConfig cfg;

	public CSVConfigDialog(Shell shell, CsvConfig initial) {
		super(shell);
		if (initial == null) {
			this.cfg = new MyCsvConfig(CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB);
		} else {
			this.cfg = new MyCsvConfig(initial);
		}
	}

	public CSVConfigDialog(Shell shell, MyCsvConfig initial) {
		super(shell);
		if (initial == null) {
			this.cfg = new MyCsvConfig(CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB);
		} else {
			this.cfg = initial;
		}
	}

	@Override
	protected boolean isResizable() {
		return true;
	}

	protected Control createDialogArea(Composite parent) {
		FormToolkit toolkit = new FormToolkit(parent.getDisplay());
		ScrolledForm root = toolkit.createScrolledForm(parent);

		root.setText(Messages.CSVConfigDialog_LbGenerator);
		root.setLayout(new GridLayout());
		root.setLayoutData(new GridData(GridData.FILL_BOTH));
		root.getBody().setLayout(new GridLayout());
		root.getBody().setLayoutData(new GridData(GridData.FILL_BOTH));

		// ---------------------------------------
		Section section2 = toolkit.createSection(root.getBody(),
				Section.EXPANDED | Section.TITLE_BAR);
		section2.setText(Messages.CSVConfigDialog_GenerateRecordsCounter);
		section2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Composite inner2 = toolkit.createComposite(section2);
		section2.setClient(inner2);
		inner2.setLayout(new GridLayout(2, false));

		try {
			toolkit.createLabel(inner2, Messages.CSVConfigDialog_ColumnRow,
					SWT.BORDER);
			final Button bt = toolkit.createButton(inner2,
					Messages.CSVConfigDialog_IncludeRowMessage, SWT.CHECK);
			bt.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					cfg.withRowColumn = bt.getSelection();
				}
			});
			bt.setSelection(cfg.withRowColumn);
			toolkit.createLabel(inner2, Messages.CSVConfigDialog_ENCODING,
					SWT.BORDER);
			final Combo encodingCombo = new Combo(inner2, SWT.SINGLE);
			encodingCombo.setItems(StringUtil.ENCODINGS);
			boolean doAddDefEncode = true;
			for (int i = 0; i < StringUtil.ENCODINGS.length; i++) {
				if (StringUtil.ENCODINGS[i].equalsIgnoreCase(cfg.getEncoding())) {
					encodingCombo.select(i);
					doAddDefEncode = false;
				}
			}
			if (doAddDefEncode) {
				encodingCombo.add(cfg.getEncoding(), 0);
				encodingCombo.select(0);
			}
			encodingCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

			encodingCombo.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					cfg.encoding = encodingCombo.getText();
				}
			});
			breakStringCombo = createComboNewLine(toolkit,
					Messages.CSVConfigDialog_breakString, cfg.getBreakString(),
					inner2);

			escapeCombo = createCombo(toolkit, Messages.CSVConfigDialog_ESCAPE,
					String.valueOf(cfg.getEscape()), inner2);
			lineSeparatorCombo = createComboNewLine(toolkit,
					Messages.CSVConfigDialog_LINE_SEPARATOR, cfg
							.getLineSeparator(), inner2);
			quoteCombo = createCombo(toolkit, Messages.CSVConfigDialog_Quote,
					String.valueOf(cfg.getQuote()), inner2);
			separetorCombo = createCombo(toolkit,
					Messages.CSVConfigDialog_SEPARATOR, String.valueOf(cfg
							.getSeparator()), inner2);
			// ---------------------------------------
			Section section3 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section3.setText("CSV Input Config");
			section3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

			Composite inner3 = toolkit.createComposite(section3);
			section3.setClient(inner3);
			inner3.setLayout(new GridLayout(3, false));
			toolkit.createLabel(inner3, "Ignore Row Column", SWT.BORDER);
			final Button btFc = toolkit.createButton(inner3, "Ignore",
					SWT.CHECK);
			btFc.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					cfg.ignoreFirstRowColumn = btFc.getSelection();
				}
			});
			btFc.setSelection(cfg.ignoreFirstRowColumn);

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return root;
	}

	Combo escapeCombo;
	Combo breakStringCombo;
	Combo lineSeparatorCombo;
	Combo quoteCombo;
	Combo separetorCombo;

	private Combo createCombo(FormToolkit toolkit, String labelTitle,
			String value, Composite inner2) {
		toolkit.createLabel(inner2, labelTitle, SWT.BORDER);
		Combo c = new Combo(inner2, SWT.SINGLE | SWT.READ_ONLY);
		c.setItems(COMBO_TEXTS);
		for (int i = 0; i < COMBO_TEXTS.length; i++) {
			if (String.valueOf(COMBO_CODE[i]).equals(value)) {
				c.select(i);
			}
		}
		c.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		c.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				if (e.widget == escapeCombo) {
					cfg.setEscape(COMBO_CODE[escapeCombo.getSelectionIndex()]);
				} else if (e.widget == quoteCombo) {
					cfg.setQuote(COMBO_CODE[quoteCombo.getSelectionIndex()]);
				} else if (e.widget == separetorCombo) {
					cfg.setSeparator(COMBO_CODE[separetorCombo
							.getSelectionIndex()]);
				}
			}
		});
		return c;
	}

	private Combo createComboNewLine(FormToolkit toolkit, String labelTitle,
			String value, Composite inner2) {
		toolkit.createLabel(inner2, labelTitle, SWT.BORDER);
		Combo c = new Combo(inner2, SWT.SINGLE | SWT.READ_ONLY);
		c.setItems(COMBO_NEW_LINE_TEXTS[1]);
		if (value == null) {
			c.select(COMBO_NEW_LINE_TEXTS[0].length - 1);
		} else {
			for (int i = 0; i < COMBO_NEW_LINE_TEXTS[0].length - 1; i++) {
				if (COMBO_NEW_LINE_TEXTS[0][i].equals(value)) {
					c.select(i);
				}
			}
		}
		c.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		c.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				if (e.widget == breakStringCombo) {
					cfg.setBreakString(COMBO_NEW_LINE_TEXTS[0][breakStringCombo
							.getSelectionIndex()]);
				} else if (e.widget == lineSeparatorCombo) {
					cfg
							.setLineSeparator(COMBO_NEW_LINE_TEXTS[0][lineSeparatorCombo
									.getSelectionIndex()]);
				}
			}
		});
		return c;
	}

	public MyCsvConfig getConfig() {
		return cfg;
	}

	public String getEncoding() {
		return cfg.getEncoding();
	}

	public static class MyCsvConfig extends CsvConfig implements Cloneable {
		protected boolean ignoreFirstRowColumn = true;
		private boolean withRowColumn = false;
		private String encoding = StringUtil.DEFAULT_ENCODING;

		public MyCsvConfig(CsvConfig cfg) {
			super(cfg.getSeparator(), cfg.getQuote(), cfg.getEscape(), cfg
					.isQuoteDisabled(), cfg.isEscapeDisabled());
			setIgnoreEmptyLines(cfg.isIgnoreEmptyLines());
			setIgnoreCaseNullString(cfg.isIgnoreCaseNullString());
			setIgnoreLeadingWhitespaces(cfg.isIgnoreLeadingWhitespaces());
			setIgnoreTrailingWhitespaces(cfg.isIgnoreTrailingWhitespaces());
		}

		public MyCsvConfig() {
		}

		public void setEncoding(String encoding) {
			this.encoding = encoding;
		}

		public boolean isWithRowColumn() {
			return withRowColumn;
		}

		public String getEncoding() {
			return encoding;
		}

		public boolean isIgnoreFirstRowColumn() {
			return ignoreFirstRowColumn;
		}
	}

}
