/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.query;

import com.healthmarketscience.jackcess.query.Query;
import com.healthmarketscience.jackcess.query.QueryFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionQuery
extends Query {
    public UnionQuery(String name, List<Query.Row> rows, int objectId) {
        super(name, rows, objectId, Query.Type.UNION);
    }

    public String getUnionType() {
        return this.hasFlag(2) ? "" : "ALL";
    }

    public String getUnionString1() {
        return this.getUnionString("X7YZ_____1");
    }

    public String getUnionString2() {
        return this.getUnionString("X7YZ_____2");
    }

    @Override
    public List<String> getOrderings() {
        return super.getOrderings();
    }

    private String getUnionString(String id) {
        for (Query.Row row : this.getTableRows()) {
            if (!id.equals(row.name2)) continue;
            return UnionQuery.cleanUnionString(row.expression);
        }
        throw new IllegalStateException("Could not find union query with id " + id);
    }

    @Override
    protected void toSQLString(StringBuilder builder) {
        builder.append(this.getUnionString1()).append(QueryFormat.NEWLINE).append("UNION ");
        String unionType = this.getUnionType();
        if (!"".equals(unionType)) {
            builder.append(unionType).append(' ');
        }
        builder.append(this.getUnionString2());
        List<String> orderings = this.getOrderings();
        if (!orderings.isEmpty()) {
            builder.append(QueryFormat.NEWLINE).append("ORDER BY ").append(orderings);
        }
    }

    private static String cleanUnionString(String str) {
        return str.trim().replaceAll("[\r\n]+", QueryFormat.NEWLINE);
    }
}

