/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSOpenGLContext;
import org.eclipse.swt.internal.cocoa.NSOpenGLPixelFormat;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    NSOpenGLContext context;
    NSOpenGLPixelFormat pixelFormat;
    static final int MAX_ATTRIBUTES = 32;
    static final String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";

    public GLCanvas(Composite parent, int style, GLData data) {
        super(parent, style);
        if (data == null) {
            SWT.error(4);
        }
        int[] attrib = new int[32];
        int pos = 0;
        if (data.doubleBuffer) {
            attrib[pos++] = 5;
        }
        if (data.stereo) {
            attrib[pos++] = 6;
        }
        if (data.redSize + data.blueSize + data.greenSize > 0) {
            attrib[pos++] = 8;
            attrib[pos++] = data.redSize + data.greenSize + data.blueSize;
        }
        if (data.alphaSize > 0) {
            attrib[pos++] = 11;
            attrib[pos++] = data.alphaSize;
        }
        if (data.depthSize > 0) {
            attrib[pos++] = 12;
            attrib[pos++] = data.depthSize;
        }
        if (data.stencilSize > 0) {
            attrib[pos++] = 13;
            attrib[pos++] = data.stencilSize;
        }
        if (data.accumRedSize + data.accumBlueSize + data.accumGreenSize > 0) {
            attrib[pos++] = 14;
            attrib[pos++] = data.accumRedSize + data.accumGreenSize + data.accumBlueSize + data.accumAlphaSize;
        }
        if (data.sampleBuffers > 0) {
            attrib[pos++] = 55;
            attrib[pos++] = data.sampleBuffers;
        }
        if (data.samples > 0) {
            attrib[pos++] = 56;
            attrib[pos++] = data.samples;
        }
        attrib[pos++] = 0;
        this.pixelFormat = (NSOpenGLPixelFormat)new NSOpenGLPixelFormat().alloc();
        if (this.pixelFormat == null) {
            this.dispose();
            SWT.error(38);
        }
        this.pixelFormat.initWithAttributes(attrib);
        NSOpenGLContext ctx = data.shareContext != null ? data.shareContext.context : null;
        this.context = (NSOpenGLContext)new NSOpenGLContext().alloc();
        if (this.context == null) {
            this.dispose();
            SWT.error(38);
        }
        this.context = this.context.initWithFormat(this.pixelFormat, ctx);
        this.setData(GLCONTEXT_KEY, this.context);
        NSNotificationCenter.defaultCenter().addObserver(this.view, OS.sel_updateOpenGLContext_, OS.NSViewGlobalFrameDidChangeNotification, this.view);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        GLCanvas.this.setData(GLCanvas.GLCONTEXT_KEY, null);
                        NSNotificationCenter.defaultCenter().removeObserver(GLCanvas.this.view);
                        if (GLCanvas.this.context != null) {
                            GLCanvas.this.context.clearDrawable();
                            GLCanvas.this.context.release();
                        }
                        GLCanvas.this.context = null;
                        if (GLCanvas.this.pixelFormat != null) {
                            GLCanvas.this.pixelFormat.release();
                        }
                        GLCanvas.this.pixelFormat = null;
                    }
                }
            }
        };
        this.addListener(12, listener);
    }

    public GLData getGLData() {
        int accumColorSize;
        int colorSize;
        this.checkWidget();
        GLData data = new GLData();
        long[] value = new long[1];
        this.pixelFormat.getValues(value, 5, 0);
        data.doubleBuffer = value[0] != 0L;
        this.pixelFormat.getValues(value, 6, 0);
        data.stereo = value[0] != 0L;
        this.pixelFormat.getValues(value, 11, 0);
        data.alphaSize = (int)value[0];
        this.pixelFormat.getValues(value, 8, 0);
        data.redSize = colorSize = (int)(value[0] - (long)data.alphaSize) / 3;
        data.greenSize = colorSize;
        data.blueSize = colorSize;
        this.pixelFormat.getValues(value, 12, 0);
        data.depthSize = (int)value[0];
        this.pixelFormat.getValues(value, 13, 0);
        data.stencilSize = (int)value[0];
        this.pixelFormat.getValues(value, 14, 0);
        data.accumRedSize = accumColorSize = (int)value[0] / 4;
        data.accumGreenSize = accumColorSize;
        data.accumBlueSize = accumColorSize;
        data.accumAlphaSize = accumColorSize;
        this.pixelFormat.getValues(value, 55, 0);
        data.sampleBuffers = (int)value[0];
        this.pixelFormat.getValues(value, 56, 0);
        data.samples = (int)value[0];
        return data;
    }

    public boolean isCurrent() {
        this.checkWidget();
        NSOpenGLContext current = NSOpenGLContext.currentContext();
        return current != null && current.id == this.context.id;
    }

    public void setCurrent() {
        this.checkWidget();
        this.context.makeCurrentContext();
    }

    public void swapBuffers() {
        this.checkWidget();
        this.context.flushBuffer();
    }
}

