package sql.mirroring;

import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.util.StringUtil;

public class MirroringFromEvernoteToHsqlTest extends AbsMirroringTest {

	@Override
	void setUpMirroringConnection() {
		for (ConnectionProperties p : bean.getConnectionSet()) {
			if (p.getDatabaseType().isEvernote()) {
				this.mirroring_from_con_properties = p;
				break;
			}
		}
		this.mirroring_to_con_properties = bean.getLocalHsqlServerConnection();
	}

	public void testMirroringHoge() {
		MirroringRequest request = new MirroringRequest(
				this.mirroring_from_con_properties,
				this.mirroring_to_con_properties);
		request.dropSchema = false;
		request.dropTable = true;
		request.cascade = true;
		request.makeBlob = true;
		request.maxRowNum = 1002;
		// request.mapToDefaultSchema("scott");
		request.putSchemaMapping("NoteBook", "EvernoteBook");
		request.putMirroringTable("NoteBook", "l_v_yonsamaのノートブック", true);
		// request.putMirroringTable("scott", "emp", true);
		// request.putMirroringTable("scott", "dept", true);
		// request.putMirroringTable("test_v_types", "test_v_table", true);

		request.addListener(new RequestAdaptor() {
			@Override
			public void beginTask(String taskName, int row) {
				System.out.println(String.format("  BEGINE %s [%d]", taskName,
						row));
			}

			@Override
			public void subTask(String subTaskName) {
				System.out.println(String.format("  SUB_TASK %s", subTaskName));
			}

			@Override
			public void called_done(Request request,
					SQLOperationType operation,
					ConnectionProperties properteis, Object o) {
				System.out.println(String.format("  DONE %s [%s]", operation,
						properteis.getDisplayString()));
			}
		});
		boolean result = SQLServerThread.runNowThisRequest(request);
		if (request.getRdh() != null) {
			System.out.println(request.getRdh());
		}
		assertTrue("Mirroring Success", result);
	}

}
