package hiro.yoshioka.sql.resource;

import java.nio.charset.Charset;
import java.util.ArrayList;

public interface IDBColumn extends IDBResource {

	public IDBTable getTable();

	public int getDataType();

	void setDataTypeString(String dataTypeString);

	String getNameWithAsComment(Charset charset);

	String getDataTypeString();

	public int getSize();

	public int getDecimalDigits();

	short getColumnType();

	public boolean isNotNull();

	public boolean isDate();

	public boolean isTime();

	public boolean isTimeStamp();

	boolean isBlob();

	boolean isBinary();

	boolean isIndex();

	public boolean isNumeric();

	public boolean isBigDecimal();

	public boolean isString();

	public boolean isIndexColumn();

	public boolean isColumnOut();

	public boolean isColumnIn();

	public boolean isColumnInOut();

	public boolean isColumnReturn();

	public void setPKey(ArrayList arraylist);

	public boolean isPkey();

	void setPKey(boolean pkey);

	public static final String PKEY = "pkey";

	public static final String TYPE = "type";

	public static final String SIZE = "size";

	public static final String NOTNULL = "notnull";

	String getProposalString();

	public int getMaxColumnNameLength();

	public void setMaxColumnNameLength(int maxColumnNameLength);

}