/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web.extension;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.arnx.jsonic.web.Container;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringContainer
extends Container {
    Log log;
    ApplicationContext appContext;

    public void init(HttpServlet servlet) throws ServletException {
        super.init(servlet);
        this.log = LogFactory.getLog(servlet.getClass());
        this.appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.context);
    }

    public Object getComponent(String className) throws Exception {
        Object component;
        try {
            component = this.appContext.getBean(className);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("class not found: " + className, e);
        }
        if (component instanceof ApplicationContextAware) {
            ((ApplicationContextAware)component).setApplicationContext(this.appContext);
        }
        for (Method method : component.getClass().getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (!Void.TYPE.equals(method.getReturnType()) || !method.getName().startsWith("set") || params.length != 1) continue;
            Class<?> c = params[0];
            if (HttpServletRequest.class.equals(c)) {
                method.invoke(component, this.request);
                continue;
            }
            if (!HttpServletResponse.class.equals(c)) continue;
            method.invoke(component, this.response);
        }
        return component;
    }

    public boolean isDebugMode() {
        return this.debug != null ? this.debug.booleanValue() : this.log.isDebugEnabled();
    }

    public void debug(String message, Throwable e) {
        if (e != null) {
            this.log.debug((Object)message, e);
        } else {
            this.log.debug((Object)message);
        }
    }

    public void warn(String message, Throwable e) {
        if (e != null) {
            this.log.warn((Object)message, e);
        } else {
            this.log.warn((Object)message);
        }
    }

    public void error(String message, Throwable e) {
        if (e != null) {
            this.log.error((Object)message, e);
        } else {
            this.log.error((Object)message);
        }
    }
}

