/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectConverter
implements Converter {
    public static final ObjectConverter INSTANCE = new ObjectConverter();

    ObjectConverter() {
    }

    @Override
    public Object convert(JSON json, JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        Map<String, PropertyInfo> props = context.getSetProperties(c);
        if (value instanceof Map) {
            Object o = json.create(context, c);
            if (o == null) {
                return null;
            }
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String name = entry.getKey().toString();
                PropertyInfo target = props.get(name);
                if (target == null) {
                    target = props.get(ClassUtil.toLowerCamel(name));
                }
                if (target == null) continue;
                context.enter(name, target.getWriteAnnotation(JSONHint.class));
                Class<?> cls = target.getWriteType();
                Type gtype = target.getWriteGenericType();
                if (gtype instanceof TypeVariable && t instanceof ParameterizedType) {
                    gtype = ObjectConverter.resolveTypeVariable((TypeVariable)gtype, (ParameterizedType)t);
                    cls = ClassUtil.getRawType(gtype);
                }
                target.set(o, json.postparse(context, entry.getValue(), cls, gtype));
                context.exit();
            }
            return o;
        }
        if (value instanceof List) {
            throw new UnsupportedOperationException();
        }
        JSONHint hint = context.getHint();
        if (hint != null && hint.anonym().length() > 0) {
            PropertyInfo target = props.get(hint.anonym());
            if (target == null) {
                return null;
            }
            Object o = json.create(context, c);
            if (o == null) {
                return null;
            }
            context.enter(hint.anonym(), target.getWriteAnnotation(JSONHint.class));
            Class<?> cls = target.getWriteType();
            Type gtype = target.getWriteGenericType();
            if (gtype instanceof TypeVariable && t instanceof ParameterizedType) {
                gtype = ObjectConverter.resolveTypeVariable((TypeVariable)gtype, (ParameterizedType)t);
                cls = ClassUtil.getRawType(gtype);
            }
            target.set(o, json.postparse(context, value, cls, gtype));
            context.exit();
            return o;
        }
        throw new UnsupportedOperationException();
    }

    private static Type resolveTypeVariable(TypeVariable<?> type, ParameterizedType parent) {
        Class<?> rawType = ClassUtil.getRawType(parent);
        if (rawType.equals(type.getGenericDeclaration())) {
            String tvName = type.getName();
            TypeVariable<Class<?>>[] rtypes = rawType.getTypeParameters();
            Type[] atypes = parent.getActualTypeArguments();
            for (int i = 0; i < rtypes.length; ++i) {
                if (!tvName.equals(rtypes[i].getName())) continue;
                return atypes[i];
            }
        }
        return type.getBounds()[0];
    }
}

