package hiro.yoshioka.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {

	private Class location;

	private String name;

	public FileUtil(Class clazz, String filename) {
		this.location = clazz;
		this.name = filename;
	}

	public static void main(String[] arg) {
		deleteEmptyFolder(new File("C:/Users/Yonsama/Documents/nuki"));
	}

	public static boolean existsAndReadableFile(File[] files) {
		for (File f : files) {
			if (!f.isFile() || !f.exists() || !f.canRead()) {
				return false;
			}
		}
		return true;
	}

	public static boolean existsAndReadableFile(String filePath) {
		return existsAndReadableFile(new File[] { new File(filePath) });
	}

	public static boolean existsAndReadableFile(File file) {
		return existsAndReadableFile(new File[] { file });
	}

	public static String[] getTexts(File f, String encode) {
		BufferedReader in = null;

		List<String> retList = new ArrayList<String>();
		try {
			if (StringUtil.isEmpty(encode)) {
				in = new BufferedReader(new FileReader(f));
			} else {
				in = new BufferedReader(new InputStreamReader(
						new FileInputStream(f), encode));
			}
			String line;

			while ((line = in.readLine()) != null) {
				retList.add(line);
			}
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return (String[]) retList.toArray(new String[retList.size()]);
	}

	public static String[] getTexts(File f) {
		return getTexts(f, null);
	}

	public static void writeFile(File file, String text, String encode) {
		PrintWriter writer = null;
		try {
			if (StringUtil.isEmpty(encode)) {
				writer = new PrintWriter(new FileWriter(file));
			} else {
				writer = new PrintWriter(new OutputStreamWriter(
						new FileOutputStream(file), encode));
			}
			writer.print(text);
			writer.flush();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (writer != null) {
				writer.close();
			}
		}
	}

	public static String getText(File f, String encode) {
		BufferedReader in = null;
		StringBuilder buf = new StringBuilder();

		try {
			if (StringUtil.isEmpty(encode)) {
				in = new BufferedReader(new FileReader(f));
			} else {
				in = new BufferedReader(new InputStreamReader(
						new FileInputStream(f), encode));
			}
			String line;

			while ((line = in.readLine()) != null) {
				buf.append(line).append(StringUtil.LINE_SEPARATOR);
			}
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return buf.toString();
	}

	public static String getText(File f) {
		return getText(f, null);
	}

	public static void deleteEmptyFolder(File dir) {
		if (dir.isDirectory()) {
			File[] children = dir.listFiles();
			if (children.length > 0) {
				for (int i = 0; i < children.length; i++) {
					if (children[i].isFile() && children[i].length() == 0) {
						children[i].delete();
					} else if (children[i].isDirectory()) {
						deleteEmptyFolder(children[i]);
					}
				}
			} else {
				dir.delete();
			}
		}
	}

	public BufferedInputStream getStream() {
		InputStream is = null;

		if (location != null) {
			is = location.getResourceAsStream(name);

		} else {
			try {
				is = new FileInputStream(name);
			} catch (FileNotFoundException e) {
				return null;
			}
		}
		if (is == null) {
			return null;
		} else {
			return new BufferedInputStream(is);
		}
	}

}
