package hiro.yoshioka.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.util.List;

import jp.sf.orangesignal.csv.Csv;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.handlers.ResultSetHandler;
import jp.sf.orangesignal.csv.handlers.StringArrayListHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CSVUtil {
	private static Log log = LogFactory.getLog(CSVUtil.class);
	public static CsvConfig QUOTE_DOUBLE_QUOTE_SEPARATE_TAB = new CsvConfig(
			StringUtil.TAB_CHAR, '"', '"');
	public static final char SEPARETOR_COMMA = ',';
	public static final char SEPARETOR_TAB = '\t';
	public static final char QUOTE_STRING_DOUBLE_QUOTE = '"';
	public static final char QUOTE_STRING_SINGLE_QUOTE = '\'';

	static {
		QUOTE_DOUBLE_QUOTE_SEPARATE_TAB.setIgnoreEmptyLines(true);
	}

	public static void main(String[] args) {

		// String[][] o = splitCSV(new File(
		// "D:/eclipse/csv/20090706_1750/HOGEP.csv"), SEPARETOR_COMMA,
		// QUOTE_STRING_DOUBLE_QUOTE);
		//
		String ta = "0030030001, o^, 003, YS1013, 2006/10/05 11:37:41\r\n"
				+ "0170170140, \"\r\n" + "2s\r\n"
				+ "₳\", 017, YS2008, 2006/10/05 13:14:21";
		String[][] o = splitByTAB_quoteDouble(ta);
		System.out.println("---- dump -----" + o.length);

		for (int i = 0; i < o.length; i++) {
			for (int j = 0; j < o[i].length; j++) {
				System.out.print(o[i][j] + ", ");
			}
			System.out.println();
		}
	}

	public static boolean save(ResultSet rs, File file, String encoding,
			CsvConfig cfg) {
		ResultSetHandler handler = new ResultSetHandler();
		try {
			Csv.save(rs, new FileOutputStream(file), encoding, cfg, handler);
			return true;
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}

	public static String[][] splitByTAB_quoteDouble(String target) {
		return split(target, QUOTE_DOUBLE_QUOTE_SEPARATE_TAB);
	}

	public static String[][] splitByTAB_quoteDouble(File target, String encoding) {
		return split(target, encoding, QUOTE_DOUBLE_QUOTE_SEPARATE_TAB);
	}

	public static String[][] split(String target, CsvConfig config) {
		try {
			List<String[]> list = Csv.load(new StringReader(target), config,
					new StringArrayListHandler());
			return list.toArray(new String[list.size()][]);
		} catch (IOException e) {
			log.error(e);
		}
		return StringUtil.EMPTY_STRING_ARRAY2;
	}

	public static String[][] split(File target, String encoding,
			CsvConfig config) {
		try {
			BufferedReader in = null;
			if (StringUtil.isEmpty(encoding)) {
				in = new BufferedReader(new FileReader(target));
			} else {
				in = new BufferedReader(new InputStreamReader(
						new FileInputStream(target), encoding));
			}
			List<String[]> list = Csv.load(in, config,
					new StringArrayListHandler());
			return list.toArray(new String[list.size()][]);
		} catch (IOException e) {
			log.error(e);
		}
		return StringUtil.EMPTY_STRING_ARRAY2;
	}

}
