package hiro.yoshioka.sdh;

import hiro.yoshioka.util.StringUtil;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class ResultSetDataHolder extends CSVRecordDataHolder {
	private static final long serialVersionUID = -4781540870053874050L;

	public static final DecimalFormat f = new DecimalFormat("#,##0.0#####");

	private long _wrap_time;

	transient protected HashMap<Integer, StringRecordData[]> fBackUpMap = new HashMap<Integer, StringRecordData[]>();

	transient public java.util.Date createTime = new java.util.Date();

	protected ResultSetMetaCopy meta;

	private boolean forUpdate;

	protected int[] pkPositions = EMPTY_INT;

	public boolean isForUpdate() {
		return forUpdate;
	}

	public void setForUpdate(boolean forUpdate) {
		this.forUpdate = forUpdate;
	}

	public ResultSetDataHolder() {
	}

	/**
	 * @param argNames
	 * @throws NullPointerException
	 */
	public ResultSetDataHolder(String[] argNames, ResultSetMetaData meta)
			throws NullPointerException {
		super(argNames);
		if (meta != null) {
			this.meta = new ResultSetMetaCopy(meta);
		}
	}

	public ResultSetDataHolder(String[] argNames) throws NullPointerException {
		this(argNames, null);
	}

	public boolean hasResultSetMetaData() {
		if (log.isDebugEnabled()) {
			log.debug("meta=" + meta);
		}
		return meta != null;
	}

	public boolean isPrimaryKey(int index) {
		for (int i = 0; i < pkPositions.length; i++) {
			if (pkPositions[i] == index) {
				return true;
			}
		}
		return false;
	}

	public int[] getPkPositions() {
		return pkPositions;
	}

	public void setPkPositions(int[] pkPositions) {
		this.pkPositions = pkPositions;
	}

	public String[] generateInsertScripts() {
		ArrayList<String> retList = new ArrayList<String>();
		for (int i = 0; i < getRowCount(); i++) {
			StringBuilder insert = new StringBuilder("");
			StringBuilder temp = new StringBuilder("");
			try {
				for (int j = 1; j <= meta.columnCount; j++) {
					if (j > 1) {
						temp.append(",");
					}
					temp.append(meta.getColumnName(j));
				}
				insert.append(String.format("INSERT INTO %s (%s) %s VALUES (",
						meta.getTableName(1), temp.toString(),
						StringUtil.LINE_SEPARATOR));

				temp = new StringBuilder();
				for (int j = 1; j <= meta.columnCount; j++) {
					if (j > 1) {
						temp.append(",");
					}
					String value = getStringData(i, meta.getColumnName(j));
					if (value.length() > 0) {
						if (isString(j) || isTimesType(j)) {
							temp.append("'" + StringUtil.cnv2SQLEscape(value)
									+ "'");
						} else {
							temp.append(value);
						}
					} else {
						temp.append("NULL");
					}
				}
				insert.append(String.format("%s); %s", temp.toString(),
						StringUtil.LINE_SEPARATOR));
				retList.add(insert.toString());
			} catch (SQLException e) {
				if (log.isInfoEnabled()) {
					log.info(StringUtil.EMPTY_STRING, e);
				}
			}
		}
		return retList.toArray(new String[retList.size()]);
	}

	class SeqNumberHolder {
		HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();

		int getMin(int keta) {
			if (keta == 0) {
				return 0;
			}
			if (keta >= 4) {
				keta = 4;
			}
			int ret = 0;
			Integer integer = map.get(new Integer(keta));
			System.out.println("keta" + keta + "/in=" + integer);
			if (integer == null) {
				String str = "0";
				if (keta >= 2) {
					str = "" + keta;
					for (int i = 0; i < keta - 1; i++) {
						str += "0";
					}
					System.out.println("str=" + str);
				}
				integer = new Integer(str);
				map.put(new Integer(keta), integer);
			}
			if (Math.pow(10, keta) > integer.intValue() + 1) {
				ret = integer.intValue();
				map.put(new Integer(keta), new Integer(integer.intValue() + 1));
			} else {
				map.remove(new Integer(keta));
				ret = getMin(keta);
			}
			System.out.println("ret=" + ret);
			return ret;
		}
	}

	public void deleteRow(int row) {
		list.remove(row);
	}

	public void clearMeta() {
		meta = null;
	}

	public void addDummyRow2(int num) {
		SeqNumberHolder seq = new SeqNumberHolder();
		HeaderData head = new HeaderData(Integer.toString(getRowCount() + 1));
		StringRecordData[] in = new StringRecordData[key.length];
		head.type = HeaderType.INSERT;
		in[0] = head;

		for (int i = 1; i < in.length; i++) {
			try {
				if (isTimeStamp(i)) {
					in[i] = new StringRecordData("");
				} else {
					in[i] = new StringRecordData(""
							+ seq.getMin(meta.getPrecision(i)));
				}
			} catch (SQLException e) {
				in[i] = new StringRecordData("");
			}
		}
		list.add(in);
	}

	public void addDummyRow(int num) {
		HeaderData head = new HeaderData(Integer.toString(getRowCount() + 1));
		StringRecordData[] in = new StringRecordData[key.length];
		head.type = HeaderType.INSERT;
		in[0] = head;
		for (int i = 1; i < in.length; i++) {
			in[i] = new StringRecordData(getMaxString(i));
		}
		list.add(in);
	}

	public long getWrapTime() {
		return _wrap_time;
	}

	public String getFormattedWrapTime() {
		return f.format(_wrap_time / 1000.0);
	}

	public void setWrapTime(long time) {
		_wrap_time = time;
	}

	/**
	 * @param index
	 * @param i
	 * @param text
	 */
	public boolean reseted(int index) {
		StringRecordData[] data1 = fBackUpMap.get(new Integer(index));
		StringRecordData[] data2 = (StringRecordData[]) list.get(index);
		if (data1 == null || data2 == null) {
			return false;
		}
		for (int i = 1; i < data1.length; i++) {
			String d1 = data1[i].getString().replaceAll("([\r\n]+)", "\n");
			String d2 = data2[i].getString().replaceAll("([\r\n]+)", "\n");
			if (!d1.equals(d2)) {
				return false;
			}
		}
		fBackUpMap.remove(new Integer(index));
		return true;
	}

	/**
	 * @param row
	 * @throws CloneNotSupportedException
	 */
	public void createBackUp(int row) throws CloneNotSupportedException {
		StringRecordData[] data = fBackUpMap.get(new Integer(row));
		if (getRowCount() <= row) {
			return;
		}
		if (data == null) {
			data = getStringRecordRow(row);
			StringRecordData[] clones = new StringRecordData[data.length];
			for (int i = 0; i < clones.length; i++) {
				clones[i] = (StringRecordData) data[i].clone();
			}
			fBackUpMap.put(new Integer(row), clones);
		}
	}

	public boolean isBlob(int index) {
		if (meta == null) {
			return false;
		}
		return meta.isBlob(index);
	}

	public boolean needsQuote(int index) {
		if (meta == null) {
			return false;
		}
		return meta.needsQuote(index);
	}

	public boolean isBinaly(int index) {
		if (meta == null) {
			return false;
		}
		return meta.isBinaly(index);
	}

	public int getSize(int index) {
		if (meta == null) {
			return 0;
		}
		try {
			return meta.getScale(index);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return 0;
	}

	public String getMaxString(int index) {
		StringBuffer buf = new StringBuffer();
		try {

			switch (meta.getColumnType(index)) {
			case Types.TIMESTAMP:
				// fRs.getMetaData().get
				break;
			case Types.NUMERIC:
			case Types.DECIMAL:
				System.out.println("lDECIMAL:"
						+ getMaxNumber(meta.getPrecision(index), meta
								.getScale(index)));
				buf.append(getMaxNumber(meta.getPrecision(index), meta
						.getScale(index)));
				break;
			default:
				buf.append(meta.getPrecision(index));
				if (buf.length() == meta.getPrecision(index) - 1) {
					buf.insert(0, "X");
				} else if (buf.length() <= meta.getPrecision(index) - 2) {
					buf.insert(0, "X");
					buf.append("X");
					for (int i = 0; buf.length() < meta.getPrecision(index); i++) {
						if (i % 2 == 0) {
							buf.insert(1, "-");
						} else {
							buf.insert(buf.length() - 1, "-");
						}
					}
				}

			}
		} catch (Exception e) {
		}
		return buf.toString();
	}

	public static String getMaxNumber(int precision, int scale) {
		StringBuffer buf = new StringBuffer();
		if (scale > 0) {
			precision -= scale;
		}
		for (int i = 0; i < precision; i++) {
			buf.append((i + 1) % 10);
		}
		if (scale > 0) {
			buf.append(".");
			for (int i = 0; i < scale; i++) {
				buf.append((i + 1) % 10);
			}
		}
		return buf.toString();
	}

	private boolean isTimeStamp(int index) throws SQLException {
		return meta.getColumnType(index) == Types.TIMESTAMP;
	}

	public boolean isTimesType(int index) throws SQLException {
		if (meta == null) {
			return false;
		}
		return meta.isTypeTimes(index);
	}

	public boolean isString(int index) {
		try {
			switch (meta.getColumnType(index)) {
			case Types.CHAR:
				return true;
			case Types.VARCHAR:
				return true;
			case Types.NCHAR:
				return true;
			case Types.NVARCHAR:
				return true;
			case Types.LONGNVARCHAR:
				return true;
			case Types.LONGVARCHAR:
				return true;
			}
		} catch (SQLException e) {
		}
		return false;
	}

	public String getYukoString(int index, String value) throws SQLException {
		if (meta == null) {
			return value;
		}
		switch (meta.getColumnType(index)) {
		case Types.TIMESTAMP:
		case Types.TIME:
		case Types.DATE:
			break;
		case Types.DECIMAL:
		case Types.NUMERIC:
		case Types.FLOAT:
		case Types.DOUBLE:
			int pre = meta.getPrecision(index);
			int scale = 0;
			try {
				scale = meta.getScale(index);
			} catch (Exception e) {
			}
			if (scale > 0) {
				pre++;
			}
			if (value.startsWith("-")) {
				pre++;
			}
			if (value.length() > pre && pre > 0) {
				return value.substring(0, pre);
			}
			break;
		default:
			int pre2 = meta.getPrecision(index);
			if (value.length() > pre2 && pre2 > 0) {
				return value.substring(0, pre2);
			}
		}
		return value;
	}

	/**
	 * @param selectionIndex
	 */
	public void setNameValue(int selectionIndex) {
		StringRecordData[] data = (StringRecordData[]) list.get(selectionIndex);
		for (int i = 1; i < data.length; i++) {
			data[i] = new StringRecordData(getMaxString(i));
		}
		try {
			createBackUp(selectionIndex);
		} catch (CloneNotSupportedException e) {
			log.fatal(StringUtil.EMPTY_STRING, e);
		}
	}

	public ResultSetDataHolder clip(int x1, int y1, int x2, int y2) {
		if (log.isDebugEnabled()) {
			log.debug("x1:" + x1 + " y1:" + y1 + " x2:" + x2 + " y2:" + y2);
		}
		if (x1 < 1 || x2 < 1) {
			throw new IllegalArgumentException("x1 ,x2  >= 1!!!!");
		}
		String[] newkey = new String[x2 - x1 + 1];

		for (int i = 0, j = x1; i < newkey.length; i++, j++) {
			newkey[i] = key[j];
		}
		ResultSetDataHolder rdh = new ResultSetDataHolder(newkey);
		for (int i = y1; i <= y2; i++) {
			if (log.isDebugEnabled()) {
				log.debug("i:" + i + " row_count:" + getRowCount());
			}
			rdh.addRow(rdh.createNewIndexOf(getRow(i), x1, x2));
		}
		return rdh;
	}

	public ResultSetDataHolder clipIndices(int[] selectionIndices) {
		String[] newkey = new String[key.length - 1];

		for (int i = 0, j = 1; i < newkey.length; i++, j++) {
			newkey[i] = key[j];
		}
		ResultSetDataHolder rdh = new ResultSetDataHolder(newkey);
		for (int i = 0; i < selectionIndices.length; i++) {
			rdh.addRowRelpaceHead(getStringRecordRow(selectionIndices[i]));
		}
		return rdh;
	}

	public boolean pasteOverrideAt(int from, ResultSetDataHolder pasetDataHolder) {
		if (from < 0 || from >= getRowCount()) {
			return false;
		}
		for (int i = 0; i < pasetDataHolder.getRowCount(); i++) {
			if (list.size() <= (from + i)) {
				if (log.isDebugEnabled()) {
					log.debug("extended row..." + list.size());
				}
				addRow((StringRecordData[]) null);
			}

			try {
				createBackUp(from + i);
			} catch (CloneNotSupportedException e) {
				log.fatal(StringUtil.EMPTY_STRING, e);
				return false;
			}
			String[] key2 = pasetDataHolder.getKey();
			for (int j = 1; j < key2.length; j++) {
				int col = getIndexByName(key2[j]);
				changeString(from + i, col, pasetDataHolder.getStringData(i,
						key2[j]));
			}
			if (reseted(from + i)) {
				changeStatus(from + i, HeaderType.NO_EDITION);
			} else {
				changeStatus(from + i, HeaderType.UPDATE);
			}
		}
		return true;
	}

	public boolean pasteOverrideAt(int from, int columnIndex, String[][] datum) {
		if (from < 0 || from >= getRowCount() || datum.length == 0) {
			return false;
		}
		boolean FirstIsHeader = true;
		for (int j = 0; j < datum[0].length; j++) {
			if (getIndexByName(datum[0][j]) < 0) {
				FirstIsHeader = false;
				break;
			}
		}
		int i = 0;
		if (FirstIsHeader) {
			i++;
		}
		for (int myrow = 0; i < datum.length; myrow++, i++) {
			if (list.size() <= (from + myrow)) {
				if (log.isDebugEnabled()) {
					log.debug("extended row..." + list.size());
				}
				addRow((StringRecordData[]) null);
			}
			try {
				createBackUp(from + i);
			} catch (CloneNotSupportedException e) {
				log.fatal(StringUtil.EMPTY_STRING, e);
				return false;
			}
			if (FirstIsHeader) {
				for (int j = 0; j < datum[0].length; j++) {
					int col = getIndexByName(datum[0][j]);
					if (log.isDebugEnabled()) {
						log.debug(from + "/" + myrow + "/" + columnIndex + "/"
								+ j + " datum=" + datum[i][j]);
					}
					if (col < 0) {
						continue;
					}
					changeString(from + myrow, col, datum[i][j]);
				}
				if (reseted(from + myrow)) {
					changeStatus(from + myrow, HeaderType.NO_EDITION);
				} else {
					changeStatus(from + myrow, HeaderType.UPDATE);
				}
			} else {
				for (int j = 0; j < datum[myrow].length; j++) {
					if (log.isDebugEnabled()) {
						log.debug(from + "/" + myrow + "/" + columnIndex + "/"
								+ j + " datum=" + datum[i][j]);
					}
					changeString(from + myrow, columnIndex + j, datum[i][j]);
				}
				if (reseted(from + myrow)) {
					changeStatus(from + myrow, HeaderType.NO_EDITION);
				} else {
					changeStatus(from + myrow, HeaderType.UPDATE);
				}
			}
		}
		return true;
	}

	private void readObject(ObjectInputStream in) throws IOException,
			ClassNotFoundException {
		in.defaultReadObject(); // Figure͈ȂRXgN^ŏ
		fBackUpMap = new HashMap<Integer, StringRecordData[]>();
	}
}