package hiro.yoshioka.sdh;

import java.io.File;
import java.io.IOException;
import java.util.List;

import jp.sf.orangesignal.csv.Csv;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.handlers.StringArrayListHandler;

public class CSVRecordDataHolder extends StringRecordDataHolder {
	private static final long serialVersionUID = -4781540870053999050L;

	static final int[] EMPTY_INT = new int[0];

	public CSVRecordDataHolder() {
	}

	public CSVRecordDataHolder(String[] argNames) throws NullPointerException {
		String[] nargNames = new String[argNames.length + 1];
		for (int i = 0; i < argNames.length; i++) {
			nargNames[i + 1] = argNames[i];
		}
		nargNames[0] = "ROW";
		key = nargNames;
	}

	public String[] getNoRowKeys() {
		String[] ret = new String[key.length - 1];
		for (int i = 0; i < ret.length; i++) {
			ret[i] = key[i + 1];
		}
		return ret;
	}

	public void addRowRelpaceHead(StringRecordData[] datas) {
		HeaderData head = new HeaderData(Integer.toString(getRowCount() + 1));

		StringRecordData[] in = new StringRecordData[datas.length];
		for (int i = 1; i < datas.length; i++) {
			try {
				in[i] = (StringRecordData) datas[i].clone();
			} catch (CloneNotSupportedException e) {
				e.printStackTrace();
			}
		}
		in[0] = head;
		list.add(in);
	}

	public void addRow(StringRecordData[] datas) {
		HeaderData head = new HeaderData(Integer.toString(getRowCount() + 1));

		if (datas == null) {
			datas = createEmptyRow();
			head.type = HeaderType.INSERT;
			datas[0] = head;
			list.add(datas);
		} else {
			StringRecordData[] in = new StringRecordData[datas.length + 1];
			for (int i = 0; i < datas.length; i++) {
				in[i + 1] = datas[i];
			}
			in[0] = head;
			list.add(in);
		}
	}

	public void changeStatus(int index, HeaderType new_type) {
		if (((HeaderData) getStringRecordRow(index)[0]).insert()) {
			if (HeaderType.UPDATE.equals(new_type)
					|| HeaderType.DELETE.equals(new_type)) {
				return;
			}
		}
		((HeaderData) getStringRecordRow(index)[0]).type = new_type;
	}

	public CSVRecordDataHolder load(File file, String encoding, CsvConfig config) {
		CSVRecordDataHolder ret = null;
		List<String[]> csvList;
		try {
			csvList = Csv.load(file, encoding, config,
					new StringArrayListHandler());
			if (csvList == null || csvList.size() == 0) {
				return null;
			}
			ret = new CSVRecordDataHolder(csvList.get(0));
			for (int i = 1; i < csvList.size(); i++) {
				ret.addRow(csvList.get(i));
			}
		} catch (IOException e) {
			log.error(e);
		}
		return ret;
	}

	public boolean toCSV(File file, String encoding, CsvConfig config) {
		try {
			Csv.save(getAllRecordList(true), file, encoding, config,
					new StringArrayListHandler());
			return true;
		} catch (IOException e) {
			log.error(e);
		}
		return false;
	}

	public class HeaderData extends StringRecordData {
		HeaderType type = HeaderType.NO_EDITION;

		public HeaderData(String string) {
			super(string);
		}

		public HeaderData(String string, HeaderType type) {
			super(string);
			this.type = type;
		}

		/**
		 * @return
		 */
		public boolean evenNumber() {
			if (fString != null && Integer.parseInt(fString) % 2 == 0) {
				return true;
			}
			return false;
		}

		public String getString() {
			return fString + type.getMark();
		}

		/**
		 * @return
		 */
		public boolean update() {
			return HeaderType.UPDATE.equals(type);
		}

		/**
		 * @return
		 */
		public boolean insert() {
			return HeaderType.INSERT.equals(type);
		}

		/**
		 * @return
		 */
		public boolean delete() {
			return HeaderType.DELETE.equals(type);
		}
	}
}