package hiro.yoshioka.util;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ColorUtil {
	static ColorRegistry registry;

	public synchronized static Color getColor(ColorNameEnum cne) {
		return getRegistry().get(cne.getColorName());
	}

	public synchronized static final ColorRegistry getRegistry() {
		if (registry == null) {
			registry = new ColorRegistry();

			Display device = Display.getCurrent();
			for (ColorNameEnum cne : ColorNameEnum.values()) {
				Color c = cne.getColor(device);
				registry.put(cne.getColorName(), c.getRGB());
			}
		}
		return registry;
	}
}
