package hiro.yoshioka.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public enum ColorNameEnum {
	/** DELETE */
	DELETE("susu", 0x88, 0x7f, 0x7a),
	/** CHANGE */
	CHANGE("momo", 0xf0, 0x91, 0x99),
	/** ADD */
	ADD("ame", 0xde, 0xb0, 0x68),
	/** NULL */
	NULL("chigusa", 0x92, 0xb5, 0xa9),
	/** SIMA */
	SIMA("wakana", 0xd8, 0xe6, 0x98),
	/** TAG */
	TAG("haizakura", 0xe8, 0xd3, 0xd1),
	/** NULL */
	SELECTION("wasurenagusa", 0xeb, 0x6e, 0xef),
	/** ASAGI(BLUE) */
	ASAGI("asagi", 0x00, 0xa3, 0xaf),
	/** SHIRAFUJI(LIGHT_GRAY) */
	SHIRAFUJI("shirafuji", 0xdb, 0xd0, 0xe6),
	/** BLACK */
	BLACK("black", SWT.COLOR_BLACK),
	/** GRAY */
	GRAY("gray", SWT.COLOR_GRAY),
	/** BLUE */
	BLUE("blue", SWT.COLOR_BLUE),
	/** CYAN */
	CYAN("cyan", SWT.COLOR_CYAN),
	/** DARK_BLUE */
	DARK_BLUE("dark_blue", SWT.COLOR_DARK_BLUE),
	/** DARK_CYAN */
	DARK_CYAN("dark_cyan", SWT.COLOR_DARK_CYAN),
	/** DARK_GRAY */
	DARK_GRAY("dark_gray", SWT.COLOR_DARK_GRAY),
	/** DARK_GREEN */
	DARK_GREEN("dark_green", SWT.COLOR_DARK_GREEN),
	/** DARK_MAGENTA */
	DARK_MAGENTA("dark_magenta", SWT.COLOR_DARK_MAGENTA),
	/** DARK_RED */
	DARK_RED("dark_red", SWT.COLOR_DARK_RED),
	/** DARK_YELLOW */
	DARK_YELLOW("dark_yellow", SWT.COLOR_DARK_YELLOW),
	/** GREEN */
	GREEN("green", SWT.COLOR_GREEN),
	/** MAGENTA */
	MAGENTA("magenta", SWT.COLOR_MAGENTA),
	/** RED */
	RED("red", SWT.COLOR_RED),
	/** YELLOW */
	YELLOW("yellow", SWT.COLOR_YELLOW);

	private String colorName;
	private int r, g, b;
	private int systemColor = Integer.MIN_VALUE;

	private ColorNameEnum(String text, int r, int g, int b) {
		this.colorName = text;
		this.r = r;
		this.g = g;
		this.b = b;
	}

	private ColorNameEnum(String text, int systemColor) {
		this.colorName = text;
		this.systemColor = systemColor;
	}

	public String getColorName() {
		return colorName;
	}

	public Color getColor(Display device) {
		if (this.systemColor == Integer.MIN_VALUE) {
			return new Color(device, r, g, b);
		}
		return device.getSystemColor(this.systemColor);
	}
}
