package hiro.yoshioka.sdh;

import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.util.SQLUtil;

public class BindObject {
	public Object target;
	public SQLDataType type;

	public BindObject(Object target, SQLDataType type) {
		this.target = target;
		this.type = type;
	}

	public BindObject(String targetString, SQLDataType columnType) {
		this.type = columnType;
		if (targetString == null) {
			this.target = null;
		} else {
			switch (columnType) {
			case BIT:
			case BOOLEAN:
				this.target = SQLUtil.getBoolean(targetString);
				break;
			case TIME:
				this.target = SQLUtil.getTime(targetString);
				return;
			case SMALLINT:
				this.target = SQLUtil.getShort(targetString);
				return;
			case INTEGER:
				this.target = SQLUtil.getInteger(targetString);
				return;
			case REAL:
			case FLOAT:
			case BIGINT:
			case NUMERIC:
			case DOUBLE:
			case DECIMAL:
				this.target = SQLUtil.getBigDecimal(targetString);
				return;
			case TIMESTAMP:
				this.target = SQLUtil.getTimeStamp(targetString);
				return;
			case DATE:
				this.target = SQLUtil.getDate(targetString);
				return;
			default:
				if (targetString.length() == 0) {
					this.target = null;
				}
			}

		}
	}

	@Override
	public String toString() {
		return " TAR{" + target + "} TYPE{" + type + "} ";
	}
}
