package hiro.yoshioka.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public enum FontNameEnum {
	/** Mono */
	Mono("mono", false, false),
	/** Mono Bold */
	Mono_Bold("mono", true, false),
	/** MS UI Gothic */
	MS_UI_Gothic("MS UI Gothic", false, false),
	/** MS_UI_Gothic Bold */
	MS_UI_Gothic_Bold("MS UI Gothic", true, false),
	/** Terminal */
	Terminal("Terminal", false, false),
	/** Terminal_14 */
	Terminal_14("Terminal", 14, false, false);

	private String fontName;
	private int size;
	private boolean bold;
	private boolean italic;

	private FontNameEnum(String name, boolean bold, boolean italic) {
		this(name, 11, bold, italic);
	}

	private FontNameEnum(String name, int size, boolean bold, boolean italic) {
		this.fontName = name;
		this.size = size;
		this.bold = bold;
		this.italic = italic;
	}

	public String getFontName() {
		return fontName;
	}

	public int getSize() {
		return size;
	}

	public boolean isBold() {
		return bold;
	}

	public boolean isItalic() {
		return italic;
	}

	public Font getFont(Display device) {
		int style = SWT.NONE;
		if (bold) {
			if (italic) {
				style = SWT.BOLD | SWT.ITALIC;
			} else {
				style = SWT.BOLD;
			}
		} else {
			if (italic) {
				style = SWT.ITALIC;
			}
		}
		return new Font(device, fontName, size, style);
	}
}
