package hiro.yoshioka.ui.multispan;

import hiro.yoshioka.sdh.IDiffSupport;
import hiro.yoshioka.sdh.ResultSetDataHolder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

import org.eclipse.swt.widgets.TableColumn;

public class SimaTable extends JTable implements IDiffSupport {
	private RowTableCellRenderer fRowTableCellRenderer = new RowTableCellRenderer();
	ExcelAdapter adapter;

	boolean supportDiff;

	public SimaTable() {
		init();
	}

	public SimaTable(ResultSetTableModel model) {
		super(model);
		init();
		int[] percentIndex = model.getPercentIdx();
		if (percentIndex.length > 0) {
			for (int pIdx : percentIndex) {
				MyIndicatorCellRenderer renderer = new MyIndicatorCellRenderer(
						0, 100);
				renderer.setStringPainted(true);
				renderer.setBackground(getBackground());

				getColumnModel().getColumn(pIdx).setCellRenderer(renderer);
			}
		}
	}

	public void setRowColor(Color c) {
		fRowTableCellRenderer.setOddRowColor(c);
	}

	public void setNullColor(Color c) {
		fRowTableCellRenderer.setNullColor(c);
	}

	public ExcelAdapter getAdapter() {
		return adapter;
	}

	private void init() {
		addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				if (getSelectedColumn() == 0) {
					setColumnSelectionInterval(0, getColumnCount() - 1);
				}
			}
		});
		setCellSelectionEnabled(true);
		setDefaultRenderer(Object.class, fRowTableCellRenderer);
		setColumnSelectionAllowed(true);
		setRowSelectionAllowed(true);
		setShowVerticalLines(true);
		setGridColor(Color.GRAY);
		setIntercellSpacing(new Dimension(4, 2));
		setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		adapter = new ExcelAdapter(this);
	}

	public void adjustHeaderWidth() {
		TableColumnModel cm = getColumnModel();
		FontMetrics fm = getFontMetrics(getFont());

		for (int i = 1; i <= cm.getColumnCount(); i++) {
			String targetString = getModel().getColumnName(i - 1);
			int maxw = fm.charsWidth(targetString.toCharArray(), 0,
					targetString.length());
			cm.getColumn(i - 1).setPreferredWidth(maxw + 10);
		}
	}

	public void adjustDataWidth() {
		TableColumnModel cm = getColumnModel();
		FontMetrics fm = getFontMetrics(getFont());

		for (int i = 1; i <= cm.getColumnCount(); i++) {
			String targetString = getModel().getColumnName(i - 1);
			int maxw = fm.charsWidth(targetString.toCharArray(), 0,
					targetString.length());
			for (int j = 0; j < getRowCount(); j++) {
				targetString = (String) getModel().getValueAt(j, i - 1);
				int mc = fm.charsWidth(targetString.toCharArray(), 0,
						targetString.length());

				if (maxw < mc) {
					maxw = mc;
				}
			}
			cm.getColumn(i - 1).setPreferredWidth(maxw + 10);
		}
	}

	public void deleteRows(int[] dels) {
		((ResultSetTableModel) getModel()).deleteRows(dels);
		repaint();

	}

	public ResultSetDataHolder getResultSetDataHolder() {
		return ((ResultSetTableModel) getModel()).rdh;
	}

	public boolean supportDiff() {
		return supportDiff;
	}

	public void setSupportDiff(boolean supportDiff) {
		this.supportDiff = supportDiff;
	}

	class MyIndicatorCellRenderer extends JProgressBar implements
			TableCellRenderer {

		public MyIndicatorCellRenderer() {
			super(JProgressBar.HORIZONTAL);
			setBorderPainted(false);
		}

		public MyIndicatorCellRenderer(int min, int max) {
			super(JProgressBar.HORIZONTAL, min, max);
			setBorderPainted(false);
		}

		public Component getTableCellRendererComponent(JTable table,
				Object value, boolean isSelected, boolean hasFocus, int row,
				int column) {
			int n = 0;
			if (!(value instanceof Number)) {
				String str;
				if (value instanceof String) {
					str = (String) value;
				} else {
					str = value.toString();
				}
				try {
					n = Integer.valueOf(str).intValue();
				} catch (NumberFormatException ex) {
				}
			} else {
				n = ((Number) value).intValue();
			}
			setValue(n);
			return this;
		}

	}
}
