package hiro.yoshioka.sdh.verify;

import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.StringRecordDataHolder;

public class RowVerifyModel {
	private VerifyAndList rowVerifyList;
	private String verifiedMessage;
	public static final String ANY_COLUMN = "$AnyColumn$";

	private String make(StringRecordDataHolder cdh, int iRow, String col,
			Object compareValue) {
		String val = cdh.getStringData(iRow, col);
		String ret = "";
		if (val.equals(compareValue)) {
			int ridx = cdh.getRightIndexByName(col);
			if (ridx >= 0) {
				ret = String
						.format("VerifyError Line:%03d code:%s KEY[%s] VALUE[%s] NEXT[%s]",
								iRow, cdh.getStringData(iRow, "code"), col,
								val,

								cdh.getStringData()[iRow][ridx]);
			} else {
				ret = String.format("VerifyError Line:%03d KEY[%s] VALUE[%s]",
						iRow, col, val);
			}
		}
		return ret;
	}

	public void verify(CSVRecordDataHolder cdh, int iRow) {
		StringBuilder buf = new StringBuilder();
		for (VerifyOrMap<String, Object> or : rowVerifyList) {
			for (String col : or.keySet()) {
				Object compareValue = or.get(col);
				if (RowVerifyModel.ANY_COLUMN.equals(col)) {
					for (String k : cdh.getNoRowKeys()) {
						buf.append(make(cdh, iRow, k, compareValue));
					}
				} else {
					buf.append(make(cdh, iRow, col, compareValue));
				}
			}
		}
		verifiedMessage = buf.toString();
	}

	public String getVerifiedMessage() {
		return verifiedMessage;
	}

	public void add(VerifyOrMap orList) {
		if (rowVerifyList == null) {
			rowVerifyList = new VerifyAndList();
		}
		rowVerifyList.add(orList);
	}
}
