package hiro.yoshioka.extract;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;

public class ArchiveUtil {
	public static final String ENCODE_MS932 = "MS932";

	// --------------------------------------------------------------------------
	// STATIC METHODS
	// --------------------------------------------------------------------------
	public static final boolean compress(String targetFolderPath,
			String zipFile, String arcExtensionPattern) {
		boolean ret = true;
		ArchiveManager obj = new ArchiveManager(arcExtensionPattern);
		obj.setExtractPath(targetFolderPath);
		obj.setFile(zipFile);
		try {
			obj.compress(ENCODE_MS932);
		} catch (Exception e) {
			ret = false;
			e.printStackTrace();
		}
		return ret;
	}

	public static final void dumpLookUp(File targetFoler,
			String lookupFileRegex, String arcExtensionPattern)
			throws FileNotFoundException, IOException {
		ArchiveManager obj = new ArchiveManager(arcExtensionPattern);
		Map<File, List<ZipEntry>> f = obj.lookup(targetFoler, lookupFileRegex);
		for (Iterator ite = f.keySet().iterator(); ite.hasNext();) {
			File key = (File) ite.next();
			System.out.println("archive file[" + key.getAbsolutePath() + "]");
			ArrayList list = (ArrayList) f.get(key);
			for (Iterator ite2 = list.iterator(); ite2.hasNext();) {
				ZipEntry ze = (ZipEntry) ite2.next();
				System.out.println("  " + ze.getName() + "/"
						+ ze.getCompressedSize() + "/" + ze.getSize());
			}
		}
	}
}
