/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.lang.reflect.InvocationTargetException;
import jp.gr.java_conf.dangan.lang.reflect.Factory;
import jp.gr.java_conf.dangan.util.lha.HashMethod;
import jp.gr.java_conf.dangan.util.lha.HashShort;
import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class HashAndBinaryTreeSearch
implements LzssSearchMethod {
    private static final int UNUSED = -1;
    private static final int ROOT_NODE = -2;
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private HashMethod hashMethod;
    private int[] hashTable;
    private int[] parent;
    private int[] small;
    private int[] large;
    private int[] dummy;

    private HashAndBinaryTreeSearch() {
    }

    public HashAndBinaryTreeSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer) {
        this(DictionarySize, MaxMatch, Threshold, TextBuffer, HashShort.class.getName());
    }

    public HashAndBinaryTreeSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer, String HashMethodClassName) {
        this.DictionarySize = DictionarySize;
        this.MaxMatch = MaxMatch;
        this.Threshold = Threshold;
        this.TextBuffer = TextBuffer;
        this.DictionaryLimit = this.DictionarySize;
        try {
            this.hashMethod = (HashMethod)Factory.createInstance(HashMethodClassName, new Object[]{TextBuffer});
        }
        catch (ClassNotFoundException exception) {
            throw new NoClassDefFoundError(exception.getMessage());
        }
        catch (InvocationTargetException exception) {
            throw new Error(exception.getTargetException().getMessage());
        }
        catch (NoSuchMethodException exception) {
            throw new NoSuchMethodError(exception.getMessage());
        }
        catch (InstantiationException exception) {
            throw new InstantiationError(exception.getMessage());
        }
        this.hashTable = new int[this.hashMethod.tableSize()];
        int i = 0;
        while (i < this.hashTable.length) {
            this.hashTable[i] = -1;
            ++i;
        }
        this.parent = new int[DictionarySize];
        this.large = new int[DictionarySize];
        this.small = new int[DictionarySize];
        i = 0;
        while (i < this.parent.length) {
            this.parent[i] = -1;
            ++i;
        }
    }

    public void put(int position) {
        this.deleteNode(position - this.DictionarySize);
        int hash = this.hashMethod.hash(position);
        int parentpos = this.hashTable[hash];
        int scanpos = this.hashTable[hash];
        byte[] buf = this.TextBuffer;
        int max = position + this.MaxMatch;
        int p = 0;
        int s = 0;
        while (scanpos != -1) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
                this.replaceNode(scanpos, position);
                return;
            }
            parentpos = scanpos;
            int n = scanpos = buf[s] < buf[p] ? this.large[scanpos & this.DictionarySize - 1] : this.small[scanpos & this.DictionarySize - 1];
        }
        if (this.hashTable[hash] != -1) {
            this.addNode(parentpos, position, p - position);
        } else {
            this.hashTable[hash] = position;
            int node = position & this.DictionarySize - 1;
            this.parent[node] = -2;
            this.small[node] = -1;
            this.large[node] = -1;
        }
    }

    public int searchAndPut(int position) {
        this.deleteNode(position - this.DictionarySize);
        int hash = this.hashMethod.hash(position);
        int matchlen = -1;
        int matchpos = this.hashTable[hash];
        int parentpos = this.hashTable[hash];
        int scanpos = this.hashTable[hash];
        byte[] buf = this.TextBuffer;
        int max = position + this.MaxMatch;
        int p = 0;
        int s = 0;
        int len = 0;
        while (scanpos != -1) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
                this.replaceNode(matchpos, position);
                return LzssOutputStream.createSearchReturn(matchlen, matchpos);
            }
            len = p - position;
            if (matchlen < len) {
                matchpos = scanpos;
                matchlen = len;
            } else if (matchlen == len && matchpos < scanpos) {
                matchpos = scanpos;
            }
            parentpos = scanpos;
            int n = scanpos = buf[s] < buf[p] ? this.large[scanpos & this.DictionarySize - 1] : this.small[scanpos & this.DictionarySize - 1];
        }
        if (this.hashTable[hash] != -1) {
            this.addNode(parentpos, position, len);
        } else {
            this.hashTable[hash] = position;
            int node = position & this.DictionarySize - 1;
            this.parent[node] = -2;
            this.small[node] = -1;
            this.large[node] = -1;
        }
        scanpos = position - this.DictionarySize;
        if (this.DictionaryLimit <= scanpos) {
            len = 0;
            while (this.TextBuffer[scanpos + len] == this.TextBuffer[position + len]) {
                if (this.MaxMatch <= ++len) break;
            }
            if (matchlen < len) {
                matchpos = scanpos;
                matchlen = len;
            }
        }
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    public int search(int position, int lastPutPos) {
        int matchlen = this.Threshold - 1;
        int matchpos = position;
        int scanpos = position - 1;
        int scanlimit = Math.max(this.DictionaryLimit, lastPutPos);
        byte[] buf = this.TextBuffer;
        int max = Math.min(this.TextBuffer.length, position + this.MaxMatch);
        int s = 0;
        int p = 0;
        int len = 0;
        while (scanlimit < scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max <= ++p) break;
            }
            if (matchlen < len) {
                matchpos = scanpos;
                matchlen = len;
            }
            --scanpos;
        }
        if (this.hashMethod.hashRequires() <= this.TextBuffer.length - position) {
            int hash = this.hashMethod.hash(position);
            scanpos = this.hashTable[hash];
            scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
            while (scanpos != -1) {
                s = scanpos;
                p = position;
                while (buf[s] == buf[p]) {
                    ++s;
                    if (max <= ++p) break;
                }
                if (p >= max) break;
                len = p - position;
                if (scanlimit <= scanpos) {
                    if (matchlen < len) {
                        matchpos = scanpos;
                        matchlen = len;
                    } else if (matchlen == len && matchpos < scanpos) {
                        matchpos = scanpos;
                    }
                }
                int n = scanpos = buf[s] < buf[p] ? this.large[scanpos & this.DictionarySize - 1] : this.small[scanpos & this.DictionarySize - 1];
            }
        }
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    public void slide() {
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        this.slideTree(this.hashTable);
        this.slideTree(this.parent);
        this.slideTree(this.small);
        this.slideTree(this.large);
    }

    public int putRequires() {
        return this.MaxMatch;
    }

    private void addNode(int parentpos, int position, int len) {
        int parentnode = parentpos & this.DictionarySize - 1;
        int node = position & this.DictionarySize - 1;
        if (this.TextBuffer[parentpos + len] < this.TextBuffer[position + len]) {
            this.large[parentnode] = position;
        } else {
            this.small[parentnode] = position;
        }
        this.parent[node] = parentpos;
        this.small[node] = -1;
        this.large[node] = -1;
    }

    private void deleteNode(int position) {
        int node = position & this.DictionarySize - 1;
        if (this.parent[node] != -1) {
            if (this.small[node] == -1 && this.large[node] == -1) {
                this.contractNode(position, -1);
            } else if (this.small[node] == -1) {
                this.contractNode(position, this.large[node]);
            } else if (this.large[node] == -1) {
                this.contractNode(position, this.small[node]);
            } else {
                int replace = this.findNext(position);
                this.deleteNode(replace);
                this.replaceNode(position, replace);
            }
        }
    }

    private void contractNode(int oldpos, int newpos) {
        int oldnode = oldpos & this.DictionarySize - 1;
        int newnode = newpos & this.DictionarySize - 1;
        int parentpos = this.parent[oldnode];
        int parentnode = parentpos & this.DictionarySize - 1;
        if (parentpos != -2) {
            if (oldpos == this.small[parentnode]) {
                this.small[parentnode] = newpos;
            } else {
                this.large[parentnode] = newpos;
            }
        } else {
            this.hashTable[this.hashMethod.hash((int)oldpos)] = newpos;
        }
        if (newpos != -1) {
            this.parent[newnode] = parentpos;
        }
        this.parent[oldnode] = -1;
    }

    private void replaceNode(int oldpos, int newpos) {
        int oldnode = oldpos & this.DictionarySize - 1;
        int newnode = newpos & this.DictionarySize - 1;
        int parentpos = this.parent[oldnode];
        int parentnode = parentpos & this.DictionarySize - 1;
        if (parentpos != -2) {
            if (oldpos == this.small[parentnode]) {
                this.small[parentnode] = newpos;
            } else {
                this.large[parentnode] = newpos;
            }
        } else {
            this.hashTable[this.hashMethod.hash((int)oldpos)] = newpos;
        }
        this.parent[newnode] = parentpos;
        this.small[newnode] = this.small[oldnode];
        this.large[newnode] = this.large[oldnode];
        if (this.small[newnode] != -1) {
            this.parent[this.small[newnode] & this.DictionarySize - 1] = newpos;
        }
        if (this.large[newnode] != -1) {
            this.parent[this.large[newnode] & this.DictionarySize - 1] = newpos;
        }
        this.parent[oldnode] = -1;
        this.large[oldnode] = -1;
        this.small[oldnode] = -1;
    }

    private int findNext(int position) {
        int node = position & this.DictionarySize - 1;
        position = this.small[node];
        node = position & this.DictionarySize - 1;
        while (-1 != this.large[node]) {
            position = this.large[node];
            node = position & this.DictionarySize - 1;
        }
        return position;
    }

    private void slideTree(int[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = array[i] >= 0 ? array[i] - this.DictionarySize : array[i];
            ++i;
        }
    }
}

