/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

public class DynamicHuffman
implements Cloneable {
    public static final int ROOT = 0;
    private static final int MAX_WEIGHT = 32768;
    private int[] weight;
    private int[] child;
    private int[] parent;
    private int[] leafs;
    private int size;

    private DynamicHuffman() {
    }

    public DynamicHuffman(int count) {
        this(count, count);
    }

    public DynamicHuffman(int max, int first) {
        if (1 <= first && first <= max) {
            this.weight = new int[max * 2 - 1];
            this.child = new int[max * 2 - 1];
            this.parent = new int[max * 2 - 1];
            this.leafs = new int[max];
            this.size = Math.max(0, first * 2 - 1);
            int node = this.size - 1;
            int code = 0;
            while (code < first) {
                this.weight[node] = 1;
                this.child[node] = ~code;
                this.leafs[code] = node--;
                ++code;
            }
            int child = this.size - 1;
            while (node >= 0 && node != child) {
                this.weight[node] = this.weight[child] + this.weight[child - 1];
                this.child[node] = child;
                int n = node--;
                this.parent[child - 1] = n;
                this.parent[child] = n;
                child -= 2;
            }
        } else {
            if (max < first) {
                throw new IllegalArgumentException("\"max\" must be larger than \"first\".");
            }
            throw new IllegalArgumentException("\"first\" must be one or more.");
        }
    }

    public Object clone() {
        DynamicHuffman clone = new DynamicHuffman();
        clone.weight = (int[])this.weight.clone();
        clone.child = (int[])this.child.clone();
        clone.parent = (int[])this.parent.clone();
        clone.leafs = (int[])this.leafs.clone();
        clone.size = this.size;
        return clone;
    }

    public int codeToNode(int code) {
        return this.leafs[code];
    }

    public int childNode(int node) {
        return this.child[node];
    }

    public int parentNode(int node) {
        return this.parent[node];
    }

    public void update(int code) {
        if (this.weight[0] == 32768) {
            this.rebuildTree();
        }
        int node = this.leafs[code];
        while (node != 0) {
            int swapNode = node;
            while (this.weight[swapNode - 1] == this.weight[node] && swapNode - 1 > 0) {
                --swapNode;
            }
            if (node != swapNode) {
                this.swap(node, swapNode);
            }
            int n = swapNode;
            this.weight[n] = this.weight[n] + 1;
            node = this.parent[swapNode];
        }
        this.weight[0] = this.weight[0] + 1;
    }

    public void addLeaf(int code) {
        if (this.size < this.weight.length - 1) {
            int last = this.size - 1;
            int large = this.size;
            int small = this.size + 1;
            this.child[large] = this.child[last];
            this.child[small] = ~code;
            this.child[last] = small;
            this.weight[large] = this.weight[last];
            this.weight[small] = 0;
            this.leafs[this.child[large] ^ 0xFFFFFFFF] = large;
            this.leafs[this.child[small] ^ 0xFFFFFFFF] = small;
            this.parent[large] = this.parent[small] = last;
            this.size = small + 1;
            if (last == 0) {
                int n = last;
                this.weight[n] = this.weight[n] - 1;
            }
        } else {
            throw new IllegalStateException();
        }
        this.update(code);
    }

    /*
     * Unable to fully structure code
     */
    private void rebuildTree() {
        leafCount = 0;
        i = 0;
        while (i < this.size) {
            if (this.child[i] < 0) {
                this.weight[leafCount] = (this.weight[i] + 1) / 2;
                this.child[leafCount] = this.child[i];
                ++leafCount;
            }
            ++i;
        }
        --leafCount;
        position = this.size - 1;
        leafPosition = this.size - 2;
        ** GOTO lbl31
        {
            this.leafs[this.child[leafCount] ^ -1] = position;
            this.weight[position] = this.weight[leafCount];
            this.child[position--] = this.child[leafCount--];
            do {
                if (leafPosition <= position) continue block1;
                weight = this.weight[leafPosition] + this.weight[leafPosition + 1];
                while (leafCount >= 0 && this.weight[leafCount] <= weight) {
                    this.leafs[this.child[leafCount] ^ -1] = position;
                    this.weight[position] = this.weight[leafCount];
                    this.child[position--] = this.child[leafCount--];
                }
                this.weight[position] = weight;
                this.child[position] = leafPosition + 1;
                v0 = position--;
                this.parent[leafPosition + 1] = v0;
                this.parent[leafPosition] = v0;
                leafPosition -= 2;
lbl31:
                // 2 sources

            } while (position >= 0);
        }
    }

    private void swap(int i, int j) {
        if (this.child[i] < 0) {
            this.leafs[this.child[i] ^ 0xFFFFFFFF] = j;
        } else {
            int n = j;
            this.parent[this.child[i] - 1] = n;
            this.parent[this.child[i]] = n;
        }
        if (this.child[j] < 0) {
            this.leafs[this.child[j] ^ 0xFFFFFFFF] = i;
        } else {
            int n = i;
            this.parent[this.child[j] - 1] = n;
            this.parent[this.child[j]] = n;
        }
        int temp = this.child[i];
        this.child[i] = this.child[j];
        this.child[j] = temp;
        temp = this.weight[i];
        this.weight[i] = this.weight[j];
        this.weight[j] = temp;
    }
}

