package hiro.yoshioka.util;

import java.util.HashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ImageUtil {
	protected static Log fLogger = LogFactory
			.getLog(ImageUtil.class.getClass());
	// display.getSystemImage(id);
	// swtKey = SWT.ICON_INFORMATION;
	// swtKey = SWT.ICON_QUESTION;
	// swtKey = SWT.ICON_WARNING;
	// swtKey = SWT.ICON_ERROR;

	private static ImageRegistry imageRegistry;
	public static final String ACTION_00_TREE_REFRESH = "action/0v_rehresh.gif";
	public static final String ACTION_32_CONNECT = "action/32connect.gif";
	public static final String ACTION_33_DISCONNECT = "action/33disconnect.gif";
	public static final String ACTION_38_SHOW_SESSION = "action/38show_session.gif";
	public static final String ACTION_39_CANSEL = "action/39cancel.gif";
	public static final String ACTION_42_BACK = "action/42back.gif";
	public static final String ACTION_43_GO = "action/43go.gif";

	public static final String ACTION_52_reflect = "action/52reflect.gif";
	public static final String ACTION_53_SORT = "action/53sort.gif";
	public static final String ACTION_54_COMPARE = "action/54compare.gif";
	public static final String ACTION_55_IMPORT = "action/55import.gif";
	public static final String ACTION_56_EXPORT = "action/56export.gif";

	public static final String ACTION_60_EXECUTE = "action/60execute.gif";
	public static final String ACTION_61_SAVE_EDIT = "action/61save_edit.gif";
	public static final String ACTION_62_STARTED = "action/62started.gif";
	public static final String ACTION_63_CLEAR = "action/clear_co.gif";

	public static final String ACTION_70_BLOB_EXEC = "action/70blob_exec.gif";
	public static final String ACTION_80_LOCK = "action/80lock.gif";
	public static final String ACTION_90_LAYOUT = "action/90layout.gif";
	public static final String ACTION_80_PROJECT_FOLDER = "action/80project_folder.gif";
	public static final String ACTION_81_WARNING = "action/81warning.gif";
	public static final String ACTION_82_ERROR = "action/82error.gif";
	public static final String ACTION_83_INFO = "action/83info.gif";

	public static final String ACTION_HTML_ADD = "action/html_add.png";

	public static final String ACTION_RUN = "action/run_exc.gif";
	public static final String ACTION_RUNNING = "action/running.gif";
	public static final String ACTION_HELP = "action/help.gif";
	public static final String ACTION_ADD_OBJ = "action/add_obj.gif";
	public static final String ACTION_SELECT_TABLE = "action/select_table.gif";
	public static final String ACTION_SEARCH = "action/search.gif";

	public static final String DBRESOURCE_01_DATABASE = "dbresource/01database.gif";
	public static final String DBRESOURCE_02_SCHEMA = "dbresource/02schema.png";
	public static final String DBRESOURCE_03_TABLE = "dbresource/03table.gif";
	public static final String DBRESOURCE_04_VIEW = "dbresource/04view.gif";
	public static final String DBRESOURCE_05_TRIGGER = "dbresource/05trigger.gif";
	public static final String DBRESOURCE_06_PROCEDURE = "dbresource/06procedure.gif";
	public static final String DBRESOURCE_07_SYNONYM = "dbresource/07synonym.gif";
	public static final String DBRESOURCE_08_FUNCTION = "dbresource/08function.gif";
	public static final String DBRESOURCE_20_FUNCTION = "dbresource/20function.gif";
	public static final String DBRESOURCE_50_DATE = "dbresource/50date.gif";
	public static final String DBRESOURCE_51_LABEL = "dbresource/51label.gif";
	public static final String DBRESOURCE_52_GENERIC_REG = "dbresource/52genericregister_obj.gif";
	public static final String DBRESOURCE_53_NUMBER = "dbresource/53number.gif";
	public static final String DBRESOURCE_54_COLUMN = "dbresource/54column.gif";
	public static final String DBRESOURCE_55_INDEX = "dbresource/55index.gif";
	public static final String DBRESOURCE_56_TIME_OBJ = "dbresource/56time_obj.gif";

	public static final String DBRESOURCE_70_ER = "dbresource/70er.gif";
	public static final String DBRESOURCE_80_SEQUENCE = "dbresource/80_sequence.gif";

	public static final String DBRESOURCE_EV_TAG = "dbresource/ev_tag.png";

	public static final String DB_HSQL = "dbresource/hsql.png";

	private static HashMap<String, ImageDescriptor> imgMap;

	public static void createImageDescriptors() {
		if (fLogger.isTraceEnabled()) {
			fLogger.trace("started...");
		}
		imgMap = new HashMap<String, ImageDescriptor>();

		putImage(ACTION_00_TREE_REFRESH);
		putImage(ACTION_32_CONNECT);
		putImage(ACTION_33_DISCONNECT);
		putImage(ACTION_39_CANSEL);

		putImage(ACTION_80_LOCK);
		putImage(ACTION_42_BACK);
		putImage(ACTION_43_GO);

		putImage(ACTION_52_reflect);
		putImage(ACTION_53_SORT);
		putImage(ACTION_54_COMPARE);
		putImage(ACTION_55_IMPORT);
		putImage(ACTION_56_EXPORT);

		putImage(ACTION_60_EXECUTE);
		putImage(ACTION_61_SAVE_EDIT);
		putImage(ACTION_62_STARTED);
		putImage(ACTION_63_CLEAR);

		putImage(ACTION_70_BLOB_EXEC);

		putImage(ACTION_80_PROJECT_FOLDER);
		putImage(ACTION_81_WARNING);
		putImage(ACTION_82_ERROR);
		putImage(ACTION_83_INFO);

		putImage(ACTION_90_LAYOUT);

		putImage(ACTION_HTML_ADD);
		putImage(ACTION_RUN);
		putImage(ACTION_RUNNING);
		putImage(ACTION_ADD_OBJ);
		putImage(ACTION_HELP);
		putImage(ACTION_SELECT_TABLE);
		putImage(ACTION_SEARCH);

		putImage(DBRESOURCE_01_DATABASE);
		putImage(DBRESOURCE_02_SCHEMA);
		putImage(DBRESOURCE_03_TABLE);
		putImage(DBRESOURCE_04_VIEW);
		putImage(DBRESOURCE_05_TRIGGER);
		putImage(DBRESOURCE_06_PROCEDURE);
		putImage(DBRESOURCE_07_SYNONYM);
		putImage(DBRESOURCE_08_FUNCTION);
		putImage(DBRESOURCE_20_FUNCTION);
		putImage(DBRESOURCE_50_DATE);
		putImage(DBRESOURCE_51_LABEL);
		putImage(DBRESOURCE_52_GENERIC_REG);
		putImage(DBRESOURCE_53_NUMBER);
		putImage(DBRESOURCE_54_COLUMN);
		putImage(DBRESOURCE_55_INDEX);
		putImage(DBRESOURCE_56_TIME_OBJ);
		putImage(DBRESOURCE_70_ER);

		putImage(DBRESOURCE_80_SEQUENCE);

		putImage(DBRESOURCE_EV_TAG);

		putImage(DB_HSQL);
	}

	public static ImageDescriptor getImageDescriptor(String key) {
		try {
			if (imgMap == null) {
				createImageDescriptors();
			}
			return imgMap.get(key);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static Image getImage(String key) {
		try {
			if (imgMap == null) {
				createImageDescriptors();
			}
			return imageRegistry.get(key);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	private static void putImage(String imagePath) {
		ImageDescriptor descriptor = getImageFromFile(imagePath);

		if (descriptor.getImageData().height > 16) {
			descriptor = ImageDescriptor.createFromImageData(resizeImage(
					descriptor.getImageData(), 16));
		}
		imgMap.put(imagePath, descriptor);

	}

	private static ImageData resizeImage(ImageData imageData, int size) {
		int w = size;
		int h = size;
		if (imageData.height > imageData.width) {
			double div = (double) imageData.height / size;
			w = (int) (imageData.width / div);
			if (w <= 0) {
				w = 1;
			}
		} else {
			double div = (double) imageData.width / size;
			h = (int) (imageData.height / div);
			if (h <= 0) {
				h = 1;
			}
		}
		return imageData.scaledTo(w, h);
	}

	private static ImageDescriptor getImageFromFile(String path) {
		if (imageRegistry == null) {
			imageRegistry = new ImageRegistry();
		}

		ImageDescriptor ret = imageRegistry.getDescriptor(path);
		if (ret == null) {
			ret = ImageDescriptor.createFromFile(ImageUtil.class, path);
			imageRegistry.put(path, ret);
		}
		return ret;
	}

	public static final void dispose() {
		if (imageRegistry != null) {
			imageRegistry.dispose();
		}
		if (imgMap != null) {
			imgMap.clear();
			imgMap = null;
		}
	}

}
