/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail.stdimpl;

import com.google.appengine.api.mail.MailService;
import com.google.appengine.api.mail.MailServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.Join;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMTransport
extends Transport {
    private static final String ADMINS_ADDRESS = "admins";

    public GMTransport(Session session, URLName urlName) {
        super(session, urlName);
    }

    @Override
    protected boolean protocolConnect(String host, int port, String user, String password) {
        return true;
    }

    @Override
    public void sendMessage(Message message, Address[] addresses) throws MessagingException {
        BodyPart bp;
        int i;
        Address senderAddr;
        MailService service = MailServiceFactory.getMailService();
        MailService.Message msg = new MailService.Message();
        String sender = null;
        if (message instanceof MimeMessage && (senderAddr = ((MimeMessage)message).getSender()) != null) {
            sender = senderAddr.toString();
        }
        if (sender == null && message.getFrom() != null && message.getFrom().length > 0) {
            sender = message.getFrom()[0].toString();
        }
        msg.setSender(sender);
        try {
            msg.setReplyTo(Join.join(", ", message.getReplyTo()));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        boolean toAdmins = false;
        Address[] allRecipients = message.getAllRecipients();
        if (allRecipients != null) {
            for (Address addr : allRecipients) {
                if (!ADMINS_ADDRESS.equals(addr.toString())) continue;
                toAdmins = true;
            }
        }
        if (!toAdmins) {
            HashSet<String> allAddresses = new HashSet<String>();
            for (Address addr : addresses) {
                allAddresses.add(addr.toString());
            }
            msg.setTo(this.convertAddressFields(message.getRecipients(MimeMessage.RecipientType.TO), allAddresses));
            msg.setCc(this.convertAddressFields(message.getRecipients(MimeMessage.RecipientType.CC), allAddresses));
            msg.setBcc(this.convertAddressFields(message.getRecipients(MimeMessage.RecipientType.BCC), allAddresses));
        }
        msg.setSubject(message.getSubject());
        Object textObject = null;
        Object htmlObject = null;
        String textType = null;
        String htmlType = null;
        Multipart otherMessageParts = null;
        if (message.getContentType() == null) {
            try {
                textObject = message.getContent();
                textType = message.getContentType();
            }
            catch (IOException e) {
                throw new MessagingException("Getting typeless content failed", e);
            }
        }
        if (message.isMimeType("text/html")) {
            try {
                htmlObject = message.getContent();
                htmlType = message.getContentType();
            }
            catch (IOException e) {
                throw new MessagingException("Getting html content failed", e);
            }
        }
        if (message.isMimeType("text/*")) {
            try {
                textObject = message.getContent();
                textType = message.getContentType();
            }
            catch (IOException e) {
                throw new MessagingException("Getting text/* content failed", e);
            }
        }
        if (message.isMimeType("multipart/*")) {
            try {
                Multipart mp = (Multipart)message.getContent();
                for (i = 0; i < mp.getCount(); ++i) {
                    bp = mp.getBodyPart(i);
                    if (bp.isMimeType("text/plain") && textObject == null) {
                        textObject = bp.getContent();
                        textType = bp.getContentType();
                        continue;
                    }
                    if (bp.isMimeType("text/html") && htmlObject == null) {
                        htmlObject = bp.getContent();
                        htmlType = bp.getContentType();
                        continue;
                    }
                    if (otherMessageParts == null) {
                        String type = mp.getContentType();
                        assert (type.startsWith("multipart/"));
                        otherMessageParts = new MimeMultipart(type.substring("multipart/".length()));
                    }
                    otherMessageParts.addBodyPart(bp);
                }
            }
            catch (IOException e) {
                throw new MessagingException("Getting multipart content failed", e);
            }
        }
        if (textObject != null) {
            if (textObject instanceof String) {
                msg.setTextBody((String)textObject);
            } else if (textObject instanceof InputStream) {
                try {
                    msg.setTextBody(this.inputStreamToString((InputStream)textObject, textType));
                }
                catch (IOException e) {
                    throw new MessagingException("Stringifying text body failed", e);
                }
            } else {
                throw new MessagingException("Converting text body failed");
            }
        }
        if (htmlObject != null) {
            if (htmlObject instanceof String) {
                msg.setHtmlBody((String)htmlObject);
            } else if (htmlObject instanceof InputStream) {
                try {
                    msg.setHtmlBody(this.inputStreamToString((InputStream)htmlObject, htmlType));
                }
                catch (IOException e) {
                    throw new MessagingException("Stringifying html body failed", e);
                }
            } else {
                throw new MessagingException("Converting html body failed");
            }
        }
        if (otherMessageParts != null) {
            ArrayList<MailService.Attachment> attachments = new ArrayList<MailService.Attachment>(otherMessageParts.getCount());
            for (i = 0; i < otherMessageParts.getCount(); ++i) {
                byte[] data;
                String name;
                block50: {
                    bp = otherMessageParts.getBodyPart(i);
                    name = bp.getFileName();
                    try {
                        Object o = bp.getContent();
                        if (o instanceof InputStream) {
                            data = this.inputStreamToBytes((InputStream)o);
                            break block50;
                        }
                        if (o instanceof String) {
                            data = ((String)o).getBytes();
                            break block50;
                        }
                        throw new MessagingException("Converting attachment data failed");
                    }
                    catch (IOException e) {
                        throw new MessagingException("Extracting attachment data failed", e);
                    }
                }
                MailService.Attachment attachment = new MailService.Attachment(name, data);
                attachments.add(attachment);
            }
            msg.setAttachments(attachments);
        }
        try {
            if (toAdmins) {
                service.sendToAdmins(msg);
            } else {
                service.send(msg);
            }
        }
        catch (IOException e) {
            this.notifyTransportListeners(2, new Address[0], addresses, new Address[0], message);
            throw new SendFailedException("MailService IO failed", e);
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException("Illegal Arguments", e);
        }
        this.notifyTransportListeners(1, addresses, new Address[0], new Address[0], message);
    }

    private Collection<String> convertAddressFields(Address[] targetAddrs, Set<String> allAddrs) {
        if (targetAddrs == null || targetAddrs.length == 0) {
            return null;
        }
        ArrayList<String> ourAddrs = new ArrayList<String>(targetAddrs.length);
        for (Address addr : targetAddrs) {
            String email = addr.toString();
            if (!allAddrs.contains(email)) continue;
            ourAddrs.add(email);
        }
        return ourAddrs;
    }

    private String inputStreamToString(InputStream in, String type) throws IOException {
        String[] args;
        String charset = null;
        for (String arg : args = type.split(";")) {
            if (!arg.trim().startsWith("charset=")) continue;
            charset = arg.split("=")[1];
            break;
        }
        if (charset != null) {
            return new String(this.inputStreamToBytes(in), charset);
        }
        return new String(this.inputStreamToBytes(in));
    }

    private byte[] inputStreamToBytes(InputStream in) throws IOException {
        byte[] bytes = new byte[in.available()];
        int count = in.read(bytes);
        return bytes;
    }
}

