/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.Key;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Query
implements Serializable {
    private final String kind;
    private final List<SortPredicate> sortPredicates;
    private final List<FilterPredicate> filterPredicates;
    private Key ancestor;

    public Query(String kind) {
        this(kind, null);
    }

    public Query(Key ancestor) {
        this(null, ancestor);
    }

    public Query(String kind, Key ancestor) {
        if (kind == null && ancestor == null) {
            throw new IllegalArgumentException("Kind or ancestor must be set.");
        }
        this.kind = kind;
        this.ancestor = ancestor;
        this.sortPredicates = new ArrayList<SortPredicate>();
        this.filterPredicates = new ArrayList<FilterPredicate>();
    }

    public String getKind() {
        return this.kind;
    }

    String getAppId() {
        return null;
    }

    public Key getAncestor() {
        return this.ancestor;
    }

    public Query setAncestor(Key ancestor) {
        if (ancestor != null && !ancestor.isComplete()) {
            throw new IllegalArgumentException(ancestor + " is incomplete.");
        }
        if (this.kind == null && ancestor == null) {
            throw new IllegalArgumentException("Either kind or ancestor must be set.");
        }
        this.ancestor = ancestor;
        return this;
    }

    public Query addFilter(String propertyName, FilterOperator operator, Object value) {
        this.filterPredicates.add(new FilterPredicate(propertyName, operator, value));
        return this;
    }

    public List<FilterPredicate> getFilterPredicates() {
        return Collections.unmodifiableList(this.filterPredicates);
    }

    public Query addSort(String propertyName) {
        return this.addSort(propertyName, SortDirection.ASCENDING);
    }

    public Query addSort(String propertyName, SortDirection direction) {
        this.sortPredicates.add(new SortPredicate(propertyName, direction));
        return this;
    }

    public List<SortPredicate> getSortPredicates() {
        return Collections.unmodifiableList(this.sortPredicates);
    }

    public static final class FilterPredicate
    implements Serializable {
        private final String propertyName;
        private final FilterOperator operator;
        private final Object value;

        public FilterPredicate(String propertyName, FilterOperator operator, Object value) {
            if (propertyName == null) {
                throw new NullPointerException("Property name was null");
            }
            if (operator == null) {
                throw new NullPointerException("Operator was null");
            }
            if (value != null && !DataTypeUtils.isSupportedType(value.getClass())) {
                throw new IllegalArgumentException("Filters of type " + value.getClass().getName() + " are not supported");
            }
            this.propertyName = propertyName;
            this.operator = operator;
            this.value = value;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public FilterOperator getOperator() {
            return this.operator;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterPredicate that = (FilterPredicate)o;
            if (this.operator != that.operator) {
                return false;
            }
            if (!this.propertyName.equals(that.propertyName)) {
                return false;
            }
            return this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.propertyName.hashCode();
            result = 31 * result + this.operator.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    public static final class SortPredicate
    implements Serializable {
        private final String propertyName;
        private final SortDirection direction;

        public SortPredicate(String propertyName, SortDirection direction) {
            if (propertyName == null) {
                throw new NullPointerException("Property name was null");
            }
            if (direction == null) {
                throw new NullPointerException("Direction was null");
            }
            this.propertyName = propertyName;
            this.direction = direction;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public SortDirection getDirection() {
            return this.direction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortPredicate that = (SortPredicate)o;
            if (this.direction != that.direction) {
                return false;
            }
            return this.propertyName.equals(that.propertyName);
        }

        public int hashCode() {
            int result = this.propertyName.hashCode();
            result = 31 * result + this.direction.hashCode();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FilterOperator {
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL,
        EQUAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortDirection {
        ASCENDING,
        DESCENDING;

    }
}

