#pragma once

typedef unsigned int size_t;
typedef unsigned int ptrdiff_t;
//ascii
inline int isdigit(int c){
	return '0' <= c && c <= '9';
}

inline int isupper(int c){
	return ('A' <= c && c <= 'Z');
}

inline int islower(int c){
	return ('a' <= c && c <= 'z');
}

inline int isalpha(int c){
	return isupper(c) || islower(c);
}


inline int isalnum(int c){
	return isalpha(c) || isdigit(c);
}

inline int toupper(int c){
	return islower(c) ? c - 0x20 : c;
}

inline int tolower(int c){
	return isupper(c) ? c + 0x20 : c;
}

//unicode
inline int iswdigit(wchar_t c){
	return L'0' <= c && c <= L'9';
}

inline int iswupper(wchar_t c){
	return L'A' <= c && c <= L'Z';
}

inline int iswlower(wchar_t c){
	return L'a' <= c && c <= L'z';
}

inline int iswalpha(wchar_t c){
	return iswupper(c) || iswlower(c);
}

inline int iswalnum(wchar_t c){
	return iswalpha(c) || iswdigit(c);
}



inline wchar_t towupper(wchar_t c){
	return iswlower(c) ? c - 0x20 : c;
}

inline wchar_t towlower(wchar_t c){
	return iswupper(c) ? c + 0x20 : c;
}
