#include "ThreadMan.h"
#include "debug.h"
#include "typedefs.h"
#include "ProcessMan.h"

BYTE ThreadMan::buf[sizeof(ThreadMan)];


Thread::Thread(Process *p, DWORD tid, DWORD eip)
:p(p),tid(tid)
{
	DWORD gdtsize = 0x400, idtsize = 0x800;
	dtbuf.reset((BYTE *)MemMan::Inst().malloc(true, false, p->getpid()));

	dt.init((DWORD)dtbuf.get(), gdtsize - 1
		, (DWORD)dtbuf.get() + gdtsize, idtsize - 1);

	tss.reset((TSS32 *)(dtbuf.get() + gdtsize + idtsize), placementdeleter());

	init_app_gdtidt(&dt, tss.get());

	//X^bN̈Ƃ1MBU[u
	DWORD esp = p->VirtualAlloc(0xf00000, false, 0, false, 0x100);
	
	tss->ldtr = 0;
	tss->iomap = 0x40000000;
	tss->fs = tss->ds = tss->es = tss->gs = tss->ss = 1 << 3;
	tss->cs = 2 << 3;
	tss->esp = esp;
	tss->cr3 = SYSTEM_PAGE_DIRECTORY_PHY;
	tss->eflags = 0x00000202;
	tss->eax = tss->ecx = tss->edx = tss->edi = tss->esi = tss->ebp = tss->ebx = 0;
	tss->eip = eip;
}

Thread::~Thread(){
}


void Thread::seteip(DWORD eip){
	tss->eip = eip;
}

void ThreadMan::Init(void)
{
	new ((void *)buf) ThreadMan();
}

ThreadMan::ThreadMan(void)
:thlist(0)
{
	curtid = 1;
	curthread = 0;
}


ThreadMan::~ThreadMan(void)
{
}

Thread *ThreadMan::CreateThread(Process *p, DWORD eip){
	Thread t(p, curtid++, eip);
	thlist.Add(t);
	return thlist[thlist.GetCount() - 1];
}

void ThreadMan::SwitchThread(){
	if(curthread == 0){

	}

}
