/*
  x68funcs.h

  prototype dec.s for functions compatibility to X680x0

  Made by Studio Breeze. 1998, 2002


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#ifndef _X68FUNCS_H_
#define _X68FUNCS_H_

/* variables */

extern int iswindowopened;
extern int iocs_graph_home; /* 0 or 1 */

extern char fnc_func[10][32];
extern char fnc_sfunc[10][32];
extern char fnc_key[12][6];
/* ROLL UP, ROLL DOWN, INS, DEL,
   UP, LEFT, RIGHT, DOWN,
   CLR, HELP, HOME, UNDO */

/* misc functions */

extern void strmfe( char *, const char *, const char * );
extern void b_striS( char *, int, int );
extern void KNJCTRL( int, int );
#ifndef HAVE_SNPRINTF
# include "snprintf/snprintf.h"
#endif

/* X-BASIC compatible functions */

extern double val( char * );
extern int child( char * );
extern int dskf( char );
extern int mspos( int *, int * );
extern char *dtasc( unsigned int );
extern char *tmasc( unsigned int );


extern void fill( int, int, int, int, unsigned int );
extern void box( int, int, int, int, unsigned int, unsigned int );
extern int  point( int, int );
extern void line( int, int, int, int, int, int );
extern void symbol( int, int, char *, char, char, char, int, char );

/* original functions */

extern FILE *fopen2( char *, char * );
extern void STed_system_initialize( int *, char *** );

extern void update_screen(void);

#endif /* _X68FUNCS_H_ */
