/*
  win32_file.cpp
  file related drivers

  Made by Studio Breeze. 2002

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include <stdio.h>
#include <sys/stat.h>
#include <direct.h>
#include "../sted_screen.h"
#include "sted_screen_win32.h"
#define WIN32_DELETE DELETE
#undef DELETE
#include "../doslib.h"
#undef DELETE
#define DELETE WIN32_DELETE

// file related
dosmode_t
CSTedScreenWin32::FileChmod(const char* in_name, dosmode_t in_atr)
{
	struct _stat stt;

	if (!in_name) return 0;

	if (in_atr==-1) {
		if (_stat(in_name, &stt)) return 0;
		if (stt.st_mode&_S_IFDIR) return 0x10;
		return 0;
	} else {
	    return 0;
	}
}

int
CSTedScreenWin32::FileChdir(const char* in_name)
{
	if (!in_name) return -1;

	return _chdir(in_name);
}

int
CSTedScreenWin32::FileCurdir(int in_drive, char* out_buff)
{
	char* buf;
	if (!out_buff) return -1;
	if (in_drive<0 || in_drive>=27) return -1;


	buf = _getdcwd(in_drive, NULL, 128);
	if (!buf) return -1;

	::strncpy(out_buff, buf+3, 128);
	::free((void *)buf);
	return 0;
}

int
CSTedScreenWin32::FileCurdrv(void)
{
    return _getdrive()-1;
}

int
CSTedScreenWin32::FileDelete(const char* in_name)
{
	if (!in_name) return -1;
	return _unlink(in_name);
}

int
CSTedScreenWin32::FileRename(const char* in_name, const char* in_newname)
{
	if (!in_name || !in_newname) return -1;
    return rename(in_name, in_newname);
}

int
CSTedScreenWin32::FileFiles(struct _x68_filbuf *in_buff, const char *in_name, int in_atr)
{
	HANDLE h;
	char* p;
	int len;
	LPCTSTR u;
	WIN32_FIND_DATA data;
	SYSTEMTIME tm;

	if (fFileDirHandle) {
		::FindClose(fFileDirHandle);
		fFileDirHandle = NULL;
	}

	u = toUCS2(in_name, (int)::strlen(in_name), &len);
	h = ::FindFirstFile(u, &data);

	if (!h) return -3;

	if (!::FileTimeToSystemTime(&data.ftLastWriteTime, &tm)) return -3;

	in_buff->atr = (unsigned char)(data.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY?0x10:0x01);
	if (data.nFileSizeHigh>0) {
		in_buff->filelen = (unsigned int)MAXDWORD;
	} else {
		in_buff->filelen = (unsigned int)data.nFileSizeLow;
	}
	in_buff->date = (unsigned short)((tm.wYear%100)<<9 | (tm.wMonth-1)<<5 | tm.wDay);
	in_buff->time = (unsigned short)(tm.wHour<<11 | tm.wMinute<<5 | (tm.wSecond/2));
	p = (char *)toSJIS(data.cFileName, NULL);
	::strncpy(in_buff->name, p,  22);
	in_buff->name[22] = '\0';

	fFileDirHandle = h;
	
	return 0;
}

int
CSTedScreenWin32::FileNfiles(struct _x68_filbuf *in_buff)
{
	char* p;
	WIN32_FIND_DATA data;
	SYSTEMTIME tm;

	if (!fFileDirHandle) return -3;

	if (!::FindNextFile(fFileDirHandle, &data)) {
		if (::GetLastError()==ERROR_NO_MORE_FILES) {
			::FindClose(fFileDirHandle);
			fFileDirHandle = NULL;
			return -3;
		} else {
			::FindClose(fFileDirHandle);
			fFileDirHandle = NULL;
			return -3;
		}
	}

	if (!::FileTimeToSystemTime(&data.ftLastWriteTime, &tm)) {
		::FindClose(fFileDirHandle);
		fFileDirHandle = NULL;
		return -3;
	}

	in_buff->atr = (unsigned char)(data.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY?0x10:0x21);
	if (data.nFileSizeHigh>0) {
		in_buff->filelen = (unsigned int)MAXDWORD;
	} else {
		in_buff->filelen = (unsigned int)data.nFileSizeLow;
	}
	in_buff->date = (unsigned short)((tm.wYear%100)<<9 | (tm.wMonth-1)<<5 | tm.wDay);
	in_buff->time = (unsigned short)(tm.wHour<<11 | tm.wMinute<<5 | (tm.wSecond/2));
	p = (char *)toSJIS(data.cFileName, NULL);
	::strncpy(in_buff->name, p,  22);
	in_buff->name[22] = '\0';

	return 0;
}

FILE*
CSTedScreenWin32::FileFopen(const char* in_name, const char* in_mode)
{
	return ::fopen(in_name, in_mode);
}

