/*
+===========================================================================+
|                          Copyright (c) 1997-2000                          |
+---------------------------------------------------------------------------+
| File Name:                                                                |
|                                                                           |
|    CComPtr.h                                                              |
|                                                                           |
+---------------------------------------------------------------------------+
| Descriptions:                                                             |
|                                                                           |
|    Class CComPtr is a thin wrapper, which provides safe manipulation on   |
|    any interface pointers. It has several OPERATORs to make it like a     |
|    PURE interface pointer. It will AddRef() and Release() interface       |
|    pointer without your concern.                                          |
|                                                                           |
|    Actaully ATL has already provided such Smart Pointer from version 2.0. |
|    I just borrow its concept and implement it in PURE C++ so that it can  |
|    be compiled under any ANSI C/C++ Compliant compiler.                   |
|                                                                           |
+---------------------------------------------------------------------------+
| Developer(s):                                                             |
|                                                                           |
|    Xu Wen Bin                                                             |
|                                                                           |
+===========================================================================+
|                           C H A N G E    L O G                            |
+---------------------------------------------------------------------------+
|                                                                           |
|    09-16-2001    Created.                                                 |
|    09-17-2001    Modified.                                                |
|    02-21-2006    Modified.                                                |
|    10-10-2009    Modified. BY S.F.                                        |
|                                                                           |
+---------------------------------------------------------------------------+
| Note(s):                                                                  |
|                                                                           |
|    CComPtr does not support IUnknown interface. That is, you CAN'T use    |
|    CComPtr<IUnknown> to wrap an IUnknown interface pointer. Under most    |
|    conditions, IUnknown pointer will be provided by OS or HIGH layer code.|
|    So this is a reasonable LIMITATION.                                    |
|                                                                           |
+---------------------------------------------------------------------------+
*/

#ifndef _COMPTR_H_
#define _COMPTR_H_

template<class INTERFACE, const IID* piid = NULL>
class CComPtr
{
public:
	CComPtr()
	{
		interface_ = NULL;
	}

	CComPtr(INTERFACE* lPtr)
	{
		interface_ = NULL;

		if (lPtr != NULL)
		{
			interface_ = lPtr;
			interface_->AddRef();
		}
	}

	CComPtr(const CComPtr<INTERFACE, piid>& RefComPtr)
	{
		interface_ = NULL;
		interface_ = (INTERFACE*)RefComPtr;

		if (interface_)
		{
			interface_->AddRef();
		}
	}
	CComPtr(IUnknown* pIUnknown, IID iid)
	{
		interface_ = NULL;

		if (pIUnknown != NULL)
		{
			pIUnknown->QueryInterface(iid, (void**)&interface_);
		}
	}
	~CComPtr()
	{
		if (interface_)
		{
			interface_->Release();
			interface_ = NULL;
		}
	}

public:
	operator INTERFACE*() const
    {
        return interface_;
    }

	INTERFACE& operator*() const
    {
		return *interface_;
    }

	INTERFACE** operator&()
    {
        return &interface_;
    }

	INTERFACE* operator->() const
	{
		return interface_;
	}

	INTERFACE* operator=(INTERFACE* lPtr)
	{

		if (IsEqualObject(lPtr))
		{
			return interface_;
		}

		interface_->Release();
		lPtr->AddRef();
		interface_ = lPtr;
		return interface_;
	}

	INTERFACE* operator=(IUnknown* pIUnknown)
    {
		assert(pIUnknown != NULL);
		assert(piid != NULL);
        pIUnknown->QueryInterface(*piid, (void**)&interface_);
		assert(interface_ != NULL);
		return interface_;
    }

	INTERFACE* operator=(const CComPtr<INTERFACE, piid>& RefComPtr)
	{
		assert(&RefComPtr != NULL);
		interface_ = (INTERFACE*)RefComPtr;

		if (interface_)
		{
			interface_->AddRef();
		}
		return interface_;
	}

	void Attach(INTERFACE* lPtr)
    {
        if (interface_)
		{
			interface_->Release();
		}
		interface_ = lPtr;
    }

    INTERFACE* Detach()
    {
        INTERFACE* lPtr = interface_;
        interface_ = NULL;
        return lPtr;
    }

	void Release()
	{
		if (interface_)
		{
			interface_->Release();
			interface_ = NULL;
		}
	}

	bool IsEqualObject(IUnknown* pOther)
	{
		assert(pOther != NULL);
		IUnknown* pUnknown = NULL;
		interface_->QueryInterface(IID_IUnknown, (void**)&pUnknown);
        bool Result = (pOther == pUnknown) ? true : false;
		pUnknown->Release();
		return Result;
	}

    HRESULT CreateInstance(const GUID &clsid, IID iid=GUID_NULL)
	{
		if(IsEqualObject(iid, GUID_NULL)) iid=__uuidof(T);
		HRESULT hr = ::CoCreateInstance(clsid, NULL
			,CLSCTX_INPROC_SERVER
			,iid
			,(void**)(&interface_));
		return hr;
    }

private:
	INTERFACE* interface_;
};

#endif // _COMPTR_H_
