/*
	STed2 for Win32

	Made by Studio Breeze. 2002

	Started: Oct.06.2002
*/

#include "stdafx.h"
#include "STed2.h"
#include "../../win32/sted_screen_win32.h"
#include "../../win32/sted_dialogs.h"
#define MAX_LOADSTRING 100

// O[oϐ :
HINSTANCE hInst;								// ݂̃C^[tFCX
TCHAR szTitle[MAX_LOADSTRING];					// ^Cg o[̃eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// C EBhE NX

HWND hwndMain = NULL;
HMENU hmenu = NULL;
HACCEL gAccelTable = NULL;

ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

static LRESULT Player_PlayAll(CSTedScreenWin32* in_drv);
static LRESULT Player_PlayTrack(CSTedScreenWin32* in_drv);
static LRESULT Player_PlayMeas(CSTedScreenWin32* in_drv);
static LRESULT Player_PlayStop(CSTedScreenWin32* in_drv);
static LRESULT Player_ToggleTrace(CSTedScreenWin32* in_drv);
static LRESULT RhythmEdit_CurrentMeas(CSTedScreenWin32* in_drv);
static LRESULT RhythmEdit_NewMeas(CSTedScreenWin32* in_drv);

extern int main(int argc, char *argv[]);

// accessor
HWND STedGetWindow(void)
{
	return hwndMain;
}

HMENU STedGetMenu(void)
{
	return ::GetMenu(hwndMain);
}

HDC STedGetWindowDC(void)
{
	return ::GetDC(hwndMain);
}

HINSTANCE STedGetAppInstance(void)
{
	return hInst;
}
HACCEL STedGetAccelTable(void)
{
	return gAccelTable;
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR    lpCmdLine,
                     int       nCmdShow)
{
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_STED2, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	gAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_STED2);

	char* argv[2];
	argv[0] = "sted2";
	argv[1] = NULL;
	main(0, argv);

	return (int) 0;
}



ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_STED2);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCTSTR)IDC_STED2;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // O[oϐɃCX^Xi[܂B

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }
   hwndMain = hWnd;

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  ֐ : WndProc(HWND, unsigned, WORD, LONG)
//
//  ړI :  C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	RECT r;
	CSTedScreenWin32* drv;

	drv = (CSTedScreenWin32 *)GetDriver();

	switch (message) 
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		// Iꂽj[̉ :
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		case IDM_PREFS_MIDIPORTS:
			DialogBox(hInst, (LPCTSTR)IDD_PREF_MIDIDEVICE, hWnd, (DLGPROC)Dlg_MidiDevices);
			break;
		case IDM_PLAY_PLAYALL:
			return Player_PlayAll(drv);
			break;
		case IDM_PLAY_PLAYTRACK:
			return Player_PlayTrack(drv);
			break;
		case IDM_PLAY_PLAYMEASURE:
			return Player_PlayMeas(drv);
			break;
		case IDM_PLAY_STOP:
			return Player_PlayStop(drv);
			break;
		case IDM_PLAY_TRACE:
			return Player_ToggleTrace(drv);
			break;
		case IDM_EDIT_RHYTHMTRACK_CURRENTMEAS:
			return RhythmEdit_CurrentMeas(drv);
			break;
		case IDM_EDIT_RHYTHMTRACK_NEWMEAS:
			return RhythmEdit_NewMeas(drv);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;

	case WM_KEYDOWN:
		if (drv) {
			drv->NotifyKeyPressed((int)wParam);
			return 0;
		} else {
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_KEYUP:
		if (drv) {
			drv->NotifyKeyReleased((int)wParam);
			return 0;
		} else {
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_SYSKEYDOWN:
		if (wParam==VK_F10 && drv) {
			drv->NotifyKeyPressed((int)wParam);
			return 0;
		} else {
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_SYSKEYUP:
		if (wParam==VK_F10 && drv) {
			drv->NotifyKeyReleased((int)wParam);
			return 0;
		} else {
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_CHAR:
		if (drv) {
			drv->NotifyChar((int)wParam);
			return 0;
		} else {
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;

	case WM_PAINT:
		if (::GetUpdateRect(hWnd, &r, FALSE)) {
			hdc = ::BeginPaint(hWnd, &ps);
			if (drv)
				drv->Paint(&r);
			::EndPaint(hWnd, &ps);
		}
		return 0L;
		break;

	case WM_MOUSEMOVE:
		if (drv) {
			drv->NotifyPointerPosition(LOWORD(lParam), HIWORD(lParam), (int)wParam);
			return 0;
		} else
			return DefWindowProc(hWnd, message, wParam, lParam);
		break;
	case WM_LBUTTONDOWN:
		if (drv) {
			drv->NotifyPointerButtonState(EButtonLeft, EButtonOn);
			return 0;
		} else
			return DefWindowProc(hWnd, message, wParam, lParam);
		break;
	case WM_RBUTTONDOWN:
		if (drv) {
			drv->NotifyPointerButtonState(EButtonRight, EButtonOn);
			return 0;
		} else
			return DefWindowProc(hWnd, message, wParam, lParam);
		break;
	case WM_LBUTTONUP:
		if (drv) {
			drv->NotifyPointerButtonState(EButtonLeft, EButtonOff);
			return 0;
		} else
			return DefWindowProc(hWnd, message, wParam, lParam);
		break;
	case WM_RBUTTONUP:
		if (drv) {
			drv->NotifyPointerButtonState(EButtonRight, EButtonOff);
			return 0;
		} else
			return DefWindowProc(hWnd, message, wParam, lParam);
		break;

	case MM_MIM_DATA:
		if (drv) {
			drv->NotifyMidiIn((unsigned long)lParam);
		} else{
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;

	case WM_TIMER:
		if (drv) {
			drv->NotifyTimer((UINT)wParam);
		} else {
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	case WM_QUIT:
		::exit(0);
		break;

	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

extern "C" const char* get_version_id(void);
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
	{
		CSTedScreenWin32* drv;
		LPCTSTR u;
		char buf[1024];

		drv = (CSTedScreenWin32 *)GetDriver();
		if (drv) {
			::strcpy(buf, "Version ");
			::strcat(buf, get_version_id());
			u = drv->toUCS2(buf, (int)::strlen(buf), NULL);

			::SetDlgItemText(hDlg, IDC_VERSION, u);
		}
		return TRUE;
		break;
	}

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//
extern "C"
void
Exit(int in_result)
{
	::PostQuitMessage(in_result);
	::exit(in_result);
}

// player control
static LRESULT
Player_PlayAll(CSTedScreenWin32* in_drv)
{
	if (in_drv) {
		in_drv->NotifyKeyPressed(VK_NONCONVERT);
	}
	return 0;
}

static LRESULT
Player_PlayTrack(CSTedScreenWin32* in_drv)
{
	if (in_drv) {
		in_drv->NotifyKeyPressed(VK_SHIFT);
		in_drv->NotifyKeyPressed(VK_LMENU);
	}
	return 0;
}

static LRESULT
Player_PlayMeas(CSTedScreenWin32* in_drv)
{
	if (in_drv) {
		in_drv->NotifyKeyPressed(VK_LMENU);
	}
	return 0;
}

static LRESULT
Player_PlayStop(CSTedScreenWin32* in_drv)
{
	if (in_drv) {
		in_drv->NotifyKeyPressed(VK_RMENU);
	}
	return 0;
}

static LRESULT
Player_ToggleTrace(CSTedScreenWin32* in_drv)
{
	HMENU menu;
	MENUITEMINFO info;

	::ZeroMemory((void *)&info, sizeof(MENUITEMINFO));
	info.cbSize = sizeof(MENUITEMINFO);
	info.fMask = MIIM_STATE;

	menu = STedGetMenu();
	if (in_drv && menu) {
		if (::GetMenuItemInfo(menu, IDM_PLAY_TRACE, FALSE, &info)) {
			info.fState = (info.fState&MFS_CHECKED) ? MFS_UNCHECKED : MFS_CHECKED;
			::SetMenuItemInfo(menu, IDM_PLAY_TRACE, FALSE, &info);
			if (info.fState&MFS_CHECKED) {
				in_drv->NotifyKeyPressed(VK_LCONTROL);
			} else {
				in_drv->NotifyKeyReleased(VK_LCONTROL);
			}
		}
	}
	return 0;
}

static LRESULT
RhythmEdit_CurrentMeas(CSTedScreenWin32* in_drv)
{
	if (in_drv) {
		in_drv->NotifyKeyPressed(0xd8);
	}
	return 0;
}

static LRESULT
RhythmEdit_NewMeas(CSTedScreenWin32* in_drv)
{
	if (in_drv) {
		in_drv->NotifyKeyPressed(0xd9);
	}
	return 0;
}
