﻿#pragma once
/** @file
 *  @brief MIDI 
 */
#include "midi_message.h"
namespace sf {
   
  typedef boost::uint32_t delta_time_t;

  /** シーケンス・メッセージのベースクラス */
  struct シーケンスメッセージ_ベース
  {
    シーケンスメッセージ_ベース(const delta_time_t step_time_value) 
      : ステップタイム_(step_time_value) {}

    シーケンスメッセージ_ベース(const シーケンスメッセージ_ベース& src ): ステップタイム_(src.ステップタイム_) {}

    const boost::uint64_t ステップタイム() const { return ステップタイム_;}
    void ステップタイム(const boost::uint64_t value) {ステップタイム_ = value;}

    // メッセージの名前
    virtual const std::wstring& 名前()  = 0;
    // メッセージの説明
    virtual const std::wstring& メッセージの説明()  = 0;
  protected:
    delta_time_t ステップタイム_;
  };

  struct ノートメッセージ :  public シーケンスメッセージ_ベース
  {
      ノートメッセージ(delta_time_t ステップタイム,boost::uint8_t ノート,boost::uint8_t ベロシティ,delta_time_t ゲートタイム) 
          : シーケンスメッセージ_ベース(ステップタイム),ノート_(ノート),ベロシティ_(ベロシティ)
      {
      }
  private:
    delta_time_t ゲートタイム_;
    boost::uint8_t ノート_;
    boost::uint8_t ベロシティ_;
  };

  struct 小節線 : public シーケンスメッセージ_ベース
  {
    小節線(delta_time_t ステップタイム) : シーケンスメッセージ_ベース(ステップタイム){}
  };
}
