#pragma once
/*
  ==============================================================================

   This file is part of the S.F.Tracker
   Copyright 2005-7 by Satoshi Fujiwara.

   S.F.Tracker can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   S.F.Tracker is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with S.F.Tracker; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/
/** @file
 *  @author S.F. (Satoshi Fujiwara)
 */
#include "machine.h"
//#include "sequencer.h"
namespace sf {
    namespace model {

        typedef boost::ptr_deque<machine::pattern_command> input_messages_type;

        struct input_messages : public singleton<input_messages>
        {
            enum state_type {
                record,/// realtime recording
                stop/// record stop
            };

            friend struct singleton<input_messages>;
            typedef input_messages_type::iterator iterator;
            typedef input_messages_type::const_iterator const_iterator;
            typedef input_messages_type::size_type size_type;
            typedef input_messages_type::reference reference;
            typedef input_messages_type::const_reference const_reference;

            size_type size() const {return m_messages.size();}

            void push_back(input_messages_type::value_type ptr) 
            {
                mutex_type::scoped_lock lock_(mutex());
                m_messages.push_back(ptr);
            };

            void push_front(input_messages_type::value_type ptr)
            {
                mutex_type::scoped_lock lock_(mutex());
                m_messages.push_front(ptr);
                m_iter = m_messages.begin();
            }

            const bool empty() const {return m_messages.empty();};
            void clear() {m_messages.clear();m_iter = m_messages.begin();};
            
            reference front(){return m_messages.front();}
            const_reference front() const {return m_messages.front();}

            reference back(){return m_messages.back();}
            const_reference back() const {return m_messages.back();}

            iterator begin(){return m_messages.begin();}
            const_iterator begin() const {return m_messages.begin();}

            iterator end(){return m_messages.end();}
            const_iterator end() const {return m_messages.end();}

            iterator& current()
            {
                return m_iter;
            };

            const state_type& state() const 
            {
                mutex_type::scoped_lock lock_(mutex());
                return m_state;
            }

            void state(const state_type& value)
            {
                mutex_type::scoped_lock lock_(mutex());
                m_state = value;
            }  

        	void pop_front(){m_messages.pop_front();m_iter = m_messages.begin();}
            void pop_back(){m_messages.pop_back();}

            mutex_type& input_messages::mutex() const {return m_mutex;};

        private:
            input_messages();
            input_messages_type m_messages;
            mutable mutex_type m_mutex;
            state_type m_state;
            iterator m_iter;
        };
    }
}
